<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\AdvocateController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\InsuranceController;
use App\Http\Controllers\UserController;
use App\Mail\TestMail;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/rerun-users-migration', function () {
    \Illuminate\Support\Facades\Schema::dropIfExists('users');

    Artisan::call('migrate', [
        '--path' => 'database/migrations/2014_10_12_00000_create_users_table.php',
        '--force' => true
    ]);

    return 'Users table dropped and recreated.';
});


Route::get('/rerun-inspect-migration', function () {
    Artisan::call('migrate:rollback', [
        '--path' => 'database/migrations/2014_10_12_00000_create_users_table.php',
        '--force' => true
    ]);

    Artisan::call('migrate', [
        '--path' => 'database/migrations/2014_10_12_00000_create_users_table.php',
        '--force' => true
    ]);

    return 'VehicleInspect migration rolled back and re-run.';
});

Route::get('/seed-user', function () {
    if (app()->environment('local')) {
        \App\Models\User::create([
            'email' => 'test@example.com',
            'password' => bcrypt('password'),
        ]);

        return 'User seeded successfully!';
    }

    abort(403, 'Unauthorized.');
});



Route::get('/test-sendgrid', function () {
    Mail::to('techdevst@gmail.com')->send(new TestMail('Hello from SendGrid!'));
    return 'Email sent!';
});

Route::get('/test-certificate/{transactionId}', function ($transactionId) {
    $controller = new App\Http\Controllers\InsuranceController();
    return $controller->successPayment($transactionId);
});

Route::get('/welcome', function () {
    return view('welcome');
});
Route::get('/design-test', function () {
    return view('testing');
});

Route::get('/', [InsuranceController::class, "home"])->name("insurance.home");
Route::get('/buy-policy', [InsuranceController::class, "buyPolicy"])->name("insurance.policy");
Route::get('/comprehensive-insurance', [InsuranceController::class, "comprehensive"])->name("insurance.comprehensive");
Route::get('/buy-insurance', [InsuranceController::class, "thirdParty"])->name("insurance.index");
Route::get('/get-vehicle-models/{code}', [InsuranceController::class, 'getVehicleModels']);

// Add these routes to your routes/web.php file

Route::get('/claim/create', [InsuranceController::class, 'claimCreate'])->name('insurance.claim-create');
Route::post('/claim/store', [InsuranceController::class, 'claimStore'])->name('insurance.claimStore');

Route::get('/get-lgas/{state_name}', function($state_name) {
    $state = DB::table('states')->where('name', $state_name)->first();
    
    return response()->json(
        DB::table('local_governments')
            ->where('state_id', $state->id)
            ->select('id', 'name')
            ->get()
    );
});



// Show the form to enter policy number (GET)
Route::get('/certificate/search', [InsuranceController::class, 'showSearchForm'])->name('certificate.searchForm');
Route::get('/policy/renew', [InsuranceController::class, 'showRenewForm'])->name('policy.renew.form');
Route::post('/policy/renew/fetch', [InsuranceController::class, 'fetchRenewDetails'])->name('policy.renew.fetch');

// Handle form submission and redirect to certificate page (POST)
Route::post('/certificate/search', [InsuranceController::class, 'searchPolicy'])->name('certificate.search');




Route::post('/insurance/buy', [InsuranceController::class, 'postDetails'])->name('store.details');
Route::get('/paystack/callback', [InsuranceController::class, 'paystackCallback']);
Route::get('/insurance/pay', [InsuranceController::class, 'makePayment'])->name('insurance.pay');

Route::get('/insurance/payment-success/{transactionId}', [InsuranceController::class, 'successPayment'])->name('insurance.success');

Route::get('/insurance/payment-failed', [InsuranceController::class, 'failPayment'])->name('insurance.failed');
Route::get('insurance/certificate/{transactionId}', [InsuranceController::class, 'Certificate'])->name('insurance.certificate');

Route::post('/certificate/downloaded/{vehicle_id}', [InsuranceController::class, 'markAsDownloaded'])->name('certificate.downloaded');

// Advocate Registration
Route::get('advocate/registration', [UserController::class, "userForm"])->name("advocate.index");
Route::post('/bank-account', [UserController::class, 'registration'])->name('advocate.store');




Route::get('/dashboard/login', [AuthController::class, 'login'])->name('login');
Route::post('/dashboard/login', [AuthController::class, 'PostLogin'])->name('admin.account');

Route::middleware(['auth'])->prefix('Admin')->group(function () {
    // user logout
    Route::post('/dashboard/logout', [AuthController::class, 'logout'])->name('logout');
    Route::middleware(['check.permission'])->group(function () {
    Route::get('/admin/reset-password', [UserController::class, 'showResetForm'])
    ->name('admin.password.reset'); // ✅ ensure only logged-in users can access

Route::post('/admin/reset-password', [UserController::class, 'updatePassword'])
    ->name('admin.password.update');

    Route::get('dashboard', [AdminController::class, "index"])->name("admin.index");
    Route::get('dashboard/list-customer', [AdminController::class, "listCustomer"])->name("admin.listCustomer");
    Route::get('dashboard/referred-customer', [AdminController::class, "referCustomer"])->name("admin.refer");
    Route::get('dashboard/list-transaction', [AdminController::class, "listTransaction"])->name("admin.listTransaction");
Route::get('/admin/transactions/export/excel', [AdminController::class, 'exportExcel'])->name('transactions.export.excel');
Route::get('/admin/transactions/export/csv', [AdminController::class, 'exportCsv'])->name('transactions.export.csv');
Route::get('/admin/transactions/export/pdf', [AdminController::class, 'exportPdf'])->name('transactions.export.pdf');
    Route::get('dashboard/list-vehicles', [AdminController::class, "listVehicle"])->name("admin.listVehicle");
    Route::get('dashboard/inspection', [AdminController::class, "inspection"])->name("admin.inspect");
    Route::get('dashboard/advocate', [AdminController::class, "advocate"])->name("admin.advocate");
    Route::get('dashboard/response', [AdminController::class, "response"])->name("admin.response");
    Route::post('/vehicle/repush/{id}', [AdminController::class, 'repush'])->name('vehicle.repush');

    // add new admin user
    Route::post('/admin/add-user', [AdminController::class, 'store'])->name('admin.addUser');



        Route::get('dashboard', [AdminController::class, "index"])->name("admin.index")->middleware('check.permission:view');
        Route::get('dashboard/list-customer', [AdminController::class, "listCustomer"])->name("admin.listCustomer");
        Route::get('dashboard/referred-customer', [AdminController::class, "referCustomer"])->name("admin.refer");
        Route::get('dashboard/list-transaction', [AdminController::class, "listTransaction"])->name("admin.listTransaction");
        Route::get('dashboard/list-vehicles', [AdminController::class, "listVehicle"])->name("admin.listVehicle");
        Route::get('dashboard/inspection', [AdminController::class, "inspection"])->name("admin.inspect")->middleware('check.permission:view');
        Route::get('dashboard/advocate', [AdminController::class, "advocate"])->name("admin.advocate");
        Route::get('dashboard/response', [AdminController::class, "response"])->name("admin.response");
        Route::post('/vehicle/repush/{id}', [AdminController::class, 'repush'])->name('vehicle.repush')->middleware('check.permission:edit');

        // add new admin user
        Route::get('dashboard/admins', [AdminController::class, "listAdmins"])->name("admin.admins");
        Route::post('/admin/add-user', [AdminController::class, 'store'])->name('admin.addUser')->middleware('check.permission:create');
        Route::put('/admin/update-user', [AdminController::class, 'update'])->name('admin.updateUser')->middleware('check.permission:edit');


        // Route::delete('dashboard/delete-customer', [UsersController::class, "deleteCustomer"])->name("user.deleteCustomer");
        //  update customer information route
        // PUT method (requires method spoofing in HTML form)
        Route::put('/customer/update', [AdminController::class, 'updateCustomer'])->name('customer.update')->middleware('check.permission:edit');
        Route::put('/inspection/update', [AdminController::class, "inspectUpdate"])->name("inspect.inspectUpdate")->middleware('check.permission:edit');

        // advocate
        Route::get('/advocate/dashboard', [UserController::class, 'dashboard'])->name('advocate.dashboard');
        Route::get('/advocate/referrers', [UserController::class, 'referred'])->name('advocate.customer');
        Route::get('/referrers/transaction', [UserController::class, 'referrerTransaction'])->name('advocate.trans');
        Route::get('/referrers/policy', [UserController::class, 'referPolicy'])->name('advocate.policy');






        // Ambassor
        Route::get('/advocate/home', [AdvocateController::class, 'dashboard'])->name('advocate.home');
        Route::get('/advocate/referrers', [AdvocateController::class, 'referred'])->name('advocate.customer');
        Route::get('/referrers/transaction', [AdvocateController::class, 'referrerTransaction'])->name('advocate.trans');
        Route::get('/referrers/policy', [AdvocateController::class, 'referPolicy'])->name('advocate.policy');
    });
});
