
@extends('Layout.layout')

@section('content')
<div class="center-wrapper">
    <div class="main-form">
        <div class=" main-title">
            <h1 class="mb-4 text-center font-weight-bold">Enter Policy Number</h1>
        </div>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
            
        <form action="{{ route('certificate.search') }}" method="POST" novalidate>
            @csrf
            <div class="form-group">
                <label for="policy_no">Policy Number</label>
                <input 
                    type="text" 
                    name="policy_no" 
                    id="policy_no" 
                    class="form-control @error('policy_no') is-invalid @enderror" 
                    value="{{ old('policy_no') }}" 
                    placeholder="Enter your policy number" 
                    required
                />
                @error('policy_no')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <button type="submit" class="btn btn-primary btn-block">Get Certificate</button>
        </form>
    </div>
</div>
@endsection