
@extends('Layout.layout')

@section('content')
<div class="center-wrapper">
    <div class="main-form">
        <div class=" main-title">
            <h1 class="mb-4 text-center font-weight-bold">Enter Policy Or Registration Number</h1>
        </div>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
            
        <form action="{{ route('policy.renew.fetch') }}" method="POST" novalidate>
            @csrf
            
            <div class="form-group">
                <label for="identifier">Policy Or Registration Number</label>
                <input 
                    type="text" 
                    name="identifier" 
                    id="identifier" 
                    class="form-control @error('identifier') is-invalid @enderror" 
                    value="{{ old('identifier') }}" 
                    placeholder="Policy No or Reg No" 
                    required
                />
                @error('identifier')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <button type="submit" class="btn btn-primary btn-block">Get Certificate</button>
        </form>
    </div>
</div>
@endsection