
@extends('Layout.layout')

@section('content')
<div class="container" style="margin-top: 30px;">
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">Insurance Policy Details</h3>
        </div>
        <div class="panel-body">
            <div class="row" style="margin-bottom: 10px;">
                <div class="col-sm-4"><strong>Customer Name:</strong></div>
                <div class="col-sm-8">{{ $insurDetails->customer->fname }} {{ $insurDetails->customer->lname }}</div>
            </div>

            <div class="row" style="margin-bottom: 10px;">
                <div class="col-sm-4"><strong>Customer Address:</strong></div>
                <div class="col-sm-8">{{ $insurDetails->customer->address }} {{ $insurDetails->customer->lname }}</div>
            </div>

            <div class="row" style="margin-bottom: 10px;">
                <div class="col-sm-4"><strong>Customer Email:</strong></div>
                <div class="col-sm-8">{{ $insurDetails->customer->email }} {{ $insurDetails->customer->lname }}</div>
            </div>

            <div class="row" style="margin-bottom: 10px;">
                <div class="col-sm-4"><strong>Customer Contact Number:</strong></div>
                <div class="col-sm-8">{{ $insurDetails->customer->phone_no }} {{ $insurDetails->customer->lname }}</div>
            </div>

            <div class="row" style="margin-bottom: 10px;">
                <div class="col-sm-4"><strong>Insurance class:</strong></div>
                <div class="col-sm-8">{{ $insurDetails->ins_class }}</div>
            </div>

            <div class="row" style="margin-bottom: 10px;">
                <div class="col-sm-4"><strong>Vehicle Usage:</strong></div>
                <div class="col-sm-8">{{ $insurDetails->vehUsage }}</div>
            </div>

            <div class="row" style="margin-bottom: 10px;">
                <div class="col-sm-4"><strong>Vehicle Make:</strong></div>
                <div class="col-sm-8">{{ $insurDetails->carMake }}</div>
            </div>

            <div class="row" style="margin-bottom: 10px;">
                <div class="col-sm-4"><strong>Vehicle Model:</strong></div>
                <div class="col-sm-8">{{ $insurDetails->vehModel }}</div>
            </div>

            <div class="row" style="margin-bottom: 10px;">
                <div class="col-sm-4"><strong>Policy Number:</strong></div>
                <div class="col-sm-8">{{ $insurDetails->policy_no }}</div>
            </div>

            <div class="row" style="margin-bottom: 10px;">
                <div class="col-sm-4"><strong>Premium Price:</strong></div>
                <div class="col-sm-8">{{ $insurDetails->premium }}</div>
            </div>

            <!-- Add more fields if needed -->


            <div class="text-center" style="margin-top: 20px;">
                <a href="{{ route('insurance.pay', [
                    'email' => $insurDetails->customer->email,
                    'amount' => $insurDetails->premium * 100,
                    'reference' => $transaction->tnx_ref,
                    'vehicle_id' => $insurDetails->id,
                    'transaction_id' => $transaction->id,
                    'renewal' => 1
                ]) }}"
                class="btn btn-primary btn-lg">
                    <i class="glyphicon glyphicon-credit-card"></i> Make Payment
                </a>
            </div>
        </div>
    </div>
</div>

@endsection