@extends('Layout.app')

<section id="top-area">
    <header>
        <div class="container">
            <div class="row">
                <div class="col-md-4 col-xs-3" id="logo"><a href="{{ route('insurance.home') }}"><img
                            src="{{ url('Assets/img/nem.jpg') }}" alt="logo"></a></div>
                <div class="btn-responsive-menu"> <span class="bar"></span> <span class="bar"></span> <span
                        class="bar"></span> </div>
                <nav class="col-md-8 col-xs-9" id="top-nav">
                    <ul>
                        <li><a href="{{ route('policy.renew.form') }}">Renew Policy</a></li>
                        <li><a href="{{ route('certificate.searchForm') }}" id="purchase">Reprint Certificate</a></li>
                    </ul>
                </nav>
            </div><!-- End row -->
        </div><!-- End container -->
    </header> <!-- End header -->
    <div class="container">
        <div class="row">
            <div class="col-md-12 main-title">
                @if ($type === 'comprehensive')
                    <h1>Comprehensive Motor Policy</h1>
                @elseif ($type === 'enhance')
                    <h1>Enhanced Motor Policy</h1>
                @elseif ($type === 'thirdparty')
                    <h1>Third Party Motor</h1>
                @endif
                {{-- <p>This Online purchase of comprehensive insurance is subject to inspection and validation within 48 hours before activation. Please note that any false information given will render your policy invalid and will lead to cancellation.
                </p> --}}
            </div>
        </div>
    </div>
</section>


@section('content')



    <section class="container" id="main">

        <!-- Start Survey container -->
        <div id="survey_container">

            {{-- Validation Errors --}}
            @if ($errors->any())
                <div class="alert alert-danger alert-dismissible" role="alert">
                    <strong>Error!</strong> Please check the following:
                    <ul class="list-unstyled">
                        @foreach ($errors->all() as $error)
                            <li><span class="glyphicon glyphicon-remove-sign"></span> {{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            {{-- Success Message --}}
            @if (session('success'))
                <div class="alert alert-success alert-dismissible" role="alert">
                    <strong>Success!</strong> {{ session('success') }}
                </div>
            @endif

            {{-- Error Message --}}
            @if (session('error'))
                <div class="alert alert-danger alert-dismissible" role="alert">
                    <strong>Error!</strong> {{ session('error') }}
                </div>
            @endif
            <div id="top-wizard">
                <strong>Progress <span id="location"></span></strong>
                <div id="progressbar"></div>
                <div class="shadow"></div>
            </div><!-- end top-wizard -->
            <form id="wrapped" action="{{ route('store.details') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div id="middle-wizard">
                    <div class="step">
                        <div class="row">
                            <h3 class="col-md-10">Personal information</h3>
                            <div class="col-md-6">
                                <ul class="data-list">
                                    @if ($type === 'comprehensive')
                                        <input type="text" name="ins_class" value="Comprehensive Motor Third Party"
                                            hidden>
                                    @elseif ($type === 'enhance')
                                        <input type="text" name="ins_class" value="Enhance Motor Third Party" hidden>
                                    @elseif ($type === 'thirdparty')
                                        <input type="text" name="ins_class" value="Motor Third Party" hidden>
                                    @endif

                                    <li><input type="text" name="title"
                                            value="{{ old('title', session('insurance_data.title')) }}"
                                            class="required form-control" placeholder="Mr/Mrs/Miss"></li>
                                    <li><input type="text" name="fname"
                                            value="{{ old('fname', session('insurance_data.fname')) }}"
                                            class="required form-control" placeholder="First name"></li>
                                    <li><input type="text" name="lname"
                                            value="{{ old('lname', session('insurance_data.lname')) }}"
                                            class="required form-control" placeholder="Last name"></li>
                                    <li><input type="email" name="email"
                                            value="{{ old('email', session('insurance_data.email')) }}"
                                            class="required form-control" placeholder="Your Email"></li>
                                    <li><input type="text" name="phone_no"
                                            value="{{ old('phone_no', session('insurance_data.phone_no')) }}"
                                            class="required form-control" placeholder="Your Mobile Number"></li>
                                    <li>Your date of birth <input type="date" name="dob"
                                            value="{{ old('dob', session('insurance_data.dob')) }}"
                                            class="required form-control" placeholder="Your date of birth"></li>

                                    <li>
                                        <select class="form-control required" name="state" id="state-select"
                                            value="{{ old('state', session('insurance_data.state')) }}">
                                            <option value="" selected>Select State</option>
                                            @foreach ($getStates as $state)
                                                <option value="{{ $state['name'] }}">{{ $state['name'] }}</option>
                                            @endforeach
                                        </select>
                                    </li>
                                </ul>
                            </div><!-- end col-md-6 -->
                            <div class="col-md-6">
                                <ul class="data-list">

                                    <li>
                                        <select class="form-control required" name="lga" id="lga-select"
                                            value="{{ old('lga', session('insurance_data.lga')) }}">
                                            <option value="" selected>Select LGA</option>
                                        </select>
                                    </li>
                                    <li>Occupation <input type="text" name="job"
                                            value="{{ old('job', session('insurance_data.job')) }}"
                                            class="required form-control" placeholder="occupation"></li>
                                    <li>Your Location<input type="text" name="address"
                                            value="{{ old('address', session('insurance_data.address')) }}"
                                            class="required form-control" placeholder="74 Isawo Road"></li>
                                    <li><input type="text" name="tax_id"
                                            value="{{ old('tax_id', session('insurance_data.tax_id')) }}"
                                            class="required form-control" placeholder="Tax ID"></li>
                                    <li><input type="text" name="id_type"
                                            value="{{ old('id_type', session('insurance_data.id_type')) }}"
                                            class="required form-control" placeholder="Means Of Identification (eig NIN)">
                                    </li>
                                    <li><input type="text" name="id_no"
                                            value="{{ old('id_no', session('insurance_data.id_no')) }}"
                                            class="required form-control" placeholder="Identification No"></li>

                                    <li>Your BVN <input type="text" name="bvn"
                                            value="{{ old('bvn', session('insurance_data.bvn')) }}" class="form-control"
                                            placeholder="967834"></li>
                                </ul>
                                <ul class="data-list floated clearfix">
                                    <li><input name="sex" type="radio" class="required check_radio"
                                            value="Male"><label class="label_gender"> Male</label></li>
                                    <li><input name="sex" type="radio" class="required check_radio"
                                            value="Female"><label class="label_gender"> Female</label></li>
                                </ul>
                            </div><!-- end col-md-6 -->
                        </div>

                    </div>
                    <!-- end step-->

                    <!-- start step for only comprehensive and ehance-->
                    @if (in_array($type, ['comprehensive', 'enhance']))
                        <div class="step">
                            @if ($type === 'comprehensive')
                                @include('insurance.partials.comprehensive')
                            @elseif ($type === 'enhance')
                                @include('insurance.partials.enhance')
                            @endif
                        </div>
                    @endif
                    <!-- end step-->

                    <div class="step">
                        <div class="row">
                            <h3 class="col-md-10">Vehicle information</h3>
                            <div class="col-md-6">
                                <ul class="data-list">
                                    <select class="form-control required" name="carMake" id="carMake">
                                        <option value="" selected>Select make of vehicle</option>
                                        @foreach ($carMakes as $make)
                                            <!-- Store itemdesc as value, but keep code in data attribute for fetching -->
                                            <option value="{{ $make['itemdesc'] }}"
                                                data-code="{{ $make['code_to_use'] }}">{{ $make['itemdesc'] }}</option>
                                        @endforeach
                                    </select>

                                    <select class="form-control required" name="vehModel" id="carModel">
                                        <option value="" selected>Select model of vehicle</option>
                                    </select>


                                    <select class="form-control required" name="yearMake"
                                        value="{{ old('yearMake', session('insurance_data.yearMake')) }}">
                                        <option value="" selected>Select Year of Make</option>
                                        @for ($year = now()->year; $year >= 1990; $year--)
                                            <option value="{{ $year }}"
                                                {{ old('yearMake', session('insurance_data.yearMake')) == $year ? 'selected' : '' }}>
                                                {{ $year }}
                                            </option>
                                        @endfor
                                    </select>
                                    <li>Enter Start Date<input type="date" name="startDate"
                                            value="{{ old('startDate', session('insurance_data.startDate')) }}"
                                            class="required form-control" placeholder="Enter Start Date"></li>

                                    <li>
                                        <select class="form-control required" name="vehUsage"
                                            value="{{ old('vehUsage', session('insurance_data.vehUsage')) }}"
                                            id="vehUsage">
                                            <option value="" selected>Select Usage</option>
                                            <option value="Private">Private</option>
                                            <option value="Commercial">Commercial</option>
                                        </select>
                                    </li>


                                </ul>
                            </div><!-- end col-md-6 -->
                            <div class="col-md-6">
                                <ul class="data-list">
                                    <li>
                                        <input type="text" name="regNo" id="regNo" maxlength="10"
                                            value="{{ old('regNo', session('insurance_data.regNo')) }}"
                                            class="required form-control" placeholder="Registration No">

                                        <!-- Error message container -->
                                        <small id="regNoError" style="color:red; display:none;">
                                            Registration No cannot be longer than 10 characters.
                                        </small>
                                    </li>

                                    <li><input type="text" name="engNo"
                                            value="{{ old('engNo', session('insurance_data.engNo')) }}"
                                            class="required form-control" placeholder="Engine No"></li>
                                    <li>
                                        <input type="text" name="chasis" id="chasis"
                                            value="{{ old('chasis', session('insurance_data.chasis')) }}"
                                            class="required form-control" placeholder="Chasis No">

                                        <!-- Error message container -->
                                        <small id="chasisError" style="color:red; display:none;">
                                            The field must not contain zero (0) or one (1).
                                        </small>
                                    </li>

                                    <li><input type="text" name="color"
                                            value="{{ old('color', session('insurance_data.color')) }}"
                                            class="required form-control" placeholder="White"></li>

                                    {{-- for only enhance and thirdparty --}}
                                    @if (in_array($type, ['thirdparty', 'enhance']))

                                        <li>
                                            <select class="form-control required" name="vehType"
                                                value="{{ old('vehType', session('insurance_data.vehType')) }}"
                                                id="vehType">
                                                <option value="" selected>Select Category</option>
                                                @if ($vehicles->count() > 0)
                                                    @foreach ($vehicles as $car)
                                                        <option value="{{ $car->vehicle_type_name }}">
                                                            {{ $car->vehicle_type_name }}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </li>
                                    @endif
                                    @if ($type === 'thirdparty')
                                        <li><input type="text" name="premium"
                                                value="{{ old('premium', session('insurance_data.premium')) }}"
                                                class="required form-control" id="thirdparty_premium"
                                                placeholder="Premium" readonly>
                                        </li>
                                    @endif

                                </ul>
                            </div><!-- end col-md-6 -->
                        </div>
                    </div>
                    <!-- end step -->



                    <div class="step text-center">
                        <div class="row">

                            <!-- Proof of Ownership -->
                            <div class="col-sm-6">
                                <div class="upload-box">
                                    <div class="preview-box" id="previewOwnership"></div>
                                    <input type="text" name="doc_type" value="Proof of Ownership" hidden>
                                    <input type="file" id="ownershipProof" name="doc_name"
                                        class="custom-file-input required"
                                        onchange="previewFile(this, 'previewOwnership')">
                                    <label for="ownershipProof" class="upload-btn">
                                        <i class="fa fa-upload"></i> <span class="required-star">Proof of Ownership</span>
                                    </label>
                                </div>
                            </div>

                            <!-- Valid ID -->
                            <div class="col-sm-6">
                                <div class="upload-box">
                                    <div class="preview-box" id="previewID"></div>
                                    <input type="text" name="doc_id" value="Valid ID" hidden>
                                    <input type="file" id="validID" name="doc_name_id"
                                        class="custom-file-input required" onchange="previewFile(this, 'previewID')">
                                    <label for="validID" class="upload-btn">
                                        <i class="fa fa-upload"></i> <span class="required-star">Valid ID</span>
                                    </label>
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- end step -->

                    @if (in_array($type, ['comprehensive', 'enhance']))
                        <div class="step">
                            <div class="row">
                                <h3 class="col-md-10">Inspection Information</h3>

                                <div class="col-md-11">
                                    <ul class="data-list">
                                        <li>
                                            <select class="form-control required" name="ins_state"
                                                value="{{ old('ins_state', session('insurance_data.ins_state')) }}">
                                                <option value="" selected>Select State</option>
                                                @foreach ($getStates as $state)
                                                    <option value="{{ $state['name'] }}">{{ $state['name'] }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </li>

                                        <li>Inspection Address* <input type="text" name="ins_address"
                                                value="{{ old('ins_address', session('insurance_data.ins_address')) }}"
                                                class="required form-control" placeholder="67 ikorodu road"></li>

                                        <li>Preferred Date for Inspection*(Not ealier than today) <input type="date"
                                                name="ins_date"
                                                value="{{ old('ins_date', session('insurance_data.ins_date')) }}"
                                                class="required form-control"></li>


                                        <li>Contact Name*<input type="text" name="ins_person"
                                                value="{{ old('ins_person', session('insurance_data.ins_person')) }}"
                                                class="required form-control" placeholder="John Doe"></li>


                                        <li>Phone Number* <input type="text" name="ins_contact"
                                                value="{{ old('ins_contact', session('insurance_data.ins_contact')) }}"
                                                class="requireds form-control"placeholder="09046746264">
                                        </li>
                                        <p>Please note, one of our agents will contact you shortly to confirm your
                                            inspection
                                            appointment</p>

                                        <h3>Term and Conditions- “kindly note that the insurer will not be responsible for
                                            own risk liability unless the inspection has been done”.</h3>
                                    </ul>
                                </div>

                            </div>
                        </div>
                    @endif
                    <!-- end step-->




                    <div class="step">
                        @include('insurance.partials.preview')
                    </div>


                    <!-- end step -->
                    <div class="submit step" id="complete">
                        <i class="icon-check"></i>
                        <h3>Proceed To Making Payment.</h3>
                        <button type="submit" class="submit">Submit & Proceed To Payment</button>
                    </div><!-- end submit step -->
                </div><!-- end middle-wizard -->
                <div id="bottom-wizard">
                    <button type="button" name="backward" class="backward">Backward</button>
                    <button type="button" name="forward" class="forward">Forward </button>
                </div><!-- end bottom-wizard -->
            </form>
        </div>






        <script>
            function previewFile(input, previewId) {
                const previewBox = document.getElementById(previewId);
                previewBox.innerHTML = ""; // Clear previous preview

                if (input.files && input.files[0]) {
                    const file = input.files[0];
                    const reader = new FileReader();

                    // Image preview
                    if (file.type.startsWith('image/')) {
                        reader.onload = function(e) {
                            const img = document.createElement('img');
                            img.src = e.target.result;
                            previewBox.appendChild(img);
                        };
                        reader.readAsDataURL(file);
                    } else {
                        // Non-image: show file name
                        const span = document.createElement('span');
                        span.textContent = file.name;
                        previewBox.appendChild(span);
                    }
                }
            }


            const vehicleData = @json($vehicles);
            document.addEventListener('DOMContentLoaded', function() {
                const vehType = document.getElementById('vehType');
                const vehUsage = document.getElementById('vehUsage');
                const premiumField = document.getElementById('thirdparty_premium');

                function updatePremium() {
                    const selectedType = vehType.value;
                    const usage = vehUsage.value;

                    if (!selectedType || !usage) return;

                    const match = vehicleData.find(v => v.vehicle_type_name === selectedType);

                    if (match) {
                        if (usage === 'Private') {
                            premiumField.value = match.private_price;
                        } else if (usage === 'Commercial') {
                            premiumField.value = match.commercial_price;
                        } else {
                            premiumField.value = '';
                        }
                    }
                }

                vehType.addEventListener('change', updatePremium);
                vehUsage.addEventListener('change', updatePremium);
            });



            $(document).ready(function() {
                $('#carMake').on('change', function() {
                    // Get the code from the selected option's data attribute
                    var makeCode = $(this).find('option:selected').data('code');

                    if (makeCode) {
                        // Use the code to fetch models (your existing backend logic)
                        $.ajax({
                            url: '{{ config('app.url') }}/get-vehicle-models/' + makeCode,
                            type: 'GET',
                            success: function(data) {
                                $('#carModel').empty().append(
                                    '<option value="">-- Select Car Model --</option>');
                                $.each(data, function(key, value) {
                                    // Store itemdesc as value (for database), display itemdesc as text
                                    $('#carModel').append('<option value="' + value
                                        .itemdesc + '">' +
                                        value.itemdesc + '</option>');
                                });
                            }
                        });
                    } else {
                        $('#carModel').empty().append('<option value="">-- Select Car Model --</option>');
                    }
                });
            });



            //local government

            document.getElementById('state-select').addEventListener('change', function() {
                const stateId = this.value;
                const lgaSelect = document.getElementById('lga-select');

                // Clear existing options
                lgaSelect.innerHTML = '<option value="" selected>Select LGA</option>';

                if (stateId) {
                    fetch(`{{ config('app.url') }}/get-lgas/${stateId}`)
                        .then(response => response.json())
                        .then(data => {
                            data.forEach(lga => {
                                const option = document.createElement('option');
                                option.value = lga.name; // Changed from lga.id to lga.name
                                option.textContent = lga.name;
                                lgaSelect.appendChild(option);
                            });
                        });
                }
            });


            // Add this script after your existing local government script

            document.addEventListener("DOMContentLoaded", function() {
                const stateSelect = document.getElementById('state-select');
                const lgaSelect = document.getElementById('lga-select');

                // Create error message element
                const lgaErrorMessage = document.createElement('small');
                lgaErrorMessage.id = 'lgaError';
                lgaErrorMessage.style.color = 'red';
                lgaErrorMessage.style.display = 'none';
                lgaErrorMessage.style.fontSize = '14px';
                lgaErrorMessage.style.fontWeight = 'bold';
                lgaErrorMessage.textContent = 'You must select a state first';

                // Insert error message after LGA select
                lgaSelect.parentNode.appendChild(lgaErrorMessage);

                // Validate when user tries to interact with LGA dropdown
                lgaSelect.addEventListener('focus', function() {
                    if (!stateSelect.value || stateSelect.value === '') {
                        lgaErrorMessage.style.display = 'block';
                        lgaSelect.blur(); // Remove focus from LGA select
                    }
                });

                lgaSelect.addEventListener('click', function(e) {
                    if (!stateSelect.value || stateSelect.value === '') {
                        e.preventDefault();
                        lgaErrorMessage.style.display = 'block';
                    }
                });

                // Hide error message when state is selected
                stateSelect.addEventListener('change', function() {
                    if (this.value && this.value !== '') {
                        lgaErrorMessage.style.display = 'none';
                    }
                });
            });



            // Chasis and Registration validation to exclude 0 and 1
            document.addEventListener("DOMContentLoaded", function() {
                const regNoInput = document.getElementById("regNo");
                const regNoError = document.getElementById("regNoError");

                const chasisInput = document.getElementById("chasis");
                const chasisError = document.getElementById("chasisError");

                // ✅ Registration No live check (max length 10)
                regNoInput.addEventListener("input", function() {
                    if (regNoInput.value.length > 10) {
                        regNoError.style.display = "block";
                    } else {
                        regNoError.style.display = "none";
                    }
                });

                // ✅ Chasis live check (no 0 or 1 allowed)
                chasisInput.addEventListener("input", function() {
                    if (/[01]/.test(chasisInput.value)) {
                        chasisError.style.display = "block";
                    } else {
                        chasisError.style.display = "none";
                    }
                });
            });
        </script>

    </section>











@endsection
