<link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.0.1/css/bootstrap.min.css" rel="stylesheet">

<style>
    body {
        background-color: #f1f1f1;
        font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
    }

    .container{
        margin-top: 80px;
    }

    .payment-card {
        background: #fff;
        padding: 30px;
        border-radius: 8px;
        box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
    }

    .payment-card h3 {
        margin-bottom: 20px;
    }

    .table td, .table th {
        vertical-align: middle !important;
    }

    .btn-pay {
        background-color: #b30000;
        color: white;
        border: none;
        padding: 12px 30px;
        font-size: 16px;
        border-radius: 4px;
        margin-top: 20px;
    }

    .btn-pay:hover {
        background-color: #990000;
    }

    .text-center {
        text-align: center;
    }

    .ref-highlight {
        font-weight: bold;
        color: #b30000;
    }
</style>

<div class="container" id="main">
    <div class="row">
        <div class="col-md-6 col-md-offset-3 payment-card text-center">
            <h3>Confirm & Proceed to Payment</h3>
            <p>Please review your payment details before continuing.</p>

            <table class="table table-bordered">
                <tr>
                    <th>Email</th>
                    <td>{{ $email }}</td>
                </tr>
                <tr>
                    <th>Amount</th>
                    <td>₦{{ number_format($amount / 100, 2) }}</td>
                </tr>
                <tr>
                    <th>Transaction Reference</th>
                    <td class="ref-highlight">{{ $reference }}</td>
                </tr>
            </table>

            <button onclick="payWithPaystack()" class="btn btn-pay">Pay Now</button>
        </div>
    </div>
</div>

<!-- Paystack Script -->
<script src="https://js.paystack.co/v1/inline.js"></script>
<script>
function payWithPaystack(){
    var handler = PaystackPop.setup({
        key: '{{ config("services.paystack.key") }}',
        email: '{{ $email }}',
        amount: {{ $amount }},
        ref: '{{ $reference }}',
        metadata: {
            custom_fields: [
                {
                    display_name: "Vehicle ID",
                    variable_name: "vehicle_id",
                    value: "{{ $vehicle_id }}"
                }
            ]
        },
        callback: function(response){
            window.location.href = "{{ config('app.url') }}/paystack/callback?reference=" + response.reference;
        },
        onClose: function(){
            alert('Transaction cancelled');
            window.location.href = "{{ config('app.url') }}/insurance/payment-failed";
        }
    });
    handler.openIframe();
}
</script>



