
    <div class="row">
        
        
        <div class="col-md-12">
            <h3 class="col-md-10">Please confirm the information provided below before proceeding</h3>
            <!-- Personal Information -->
            <div class="preview-section">
                <h4 class="preview-heading">Personal Information</h4>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Title:</strong> <span class="preview-value" data-field="title"></span></p>
                        <p><strong>First Name:</strong> <span class="preview-value" data-field="fname"></span></p>
                        <p><strong>Last Name:</strong> <span class="preview-value" data-field="lname"></span></p>
                        <p><strong>Email:</strong> <span class="preview-value" data-field="email"></span></p>
                        <p><strong>Phone Number:</strong> <span class="preview-value" data-field="phone_no"></span></p>
                        <p><strong>Date of Birth:</strong> <span class="preview-value" data-field="dob"></span></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Gender:</strong> <span class="preview-value" data-field="sex"></span></p>
                        <p><strong>State:</strong> <span class="preview-value" data-field="state"></span></p>
                        <p><strong>LGA:</strong> <span class="preview-value" data-field="lga"></span></p>
                        <p><strong>Occupation:</strong> <span class="preview-value" data-field="job"></span></p>
                        <p><strong>Address:</strong> <span class="preview-value" data-field="address"></span></p>
                        <p><strong>Tax ID:</strong> <span class="preview-value" data-field="tax_id"></span></p>
                        <p><strong>ID Type:</strong> <span class="preview-value" data-field="id_type"></span></p>
                        <p><strong>ID Number:</strong> <span class="preview-value" data-field="id_no"></span></p>
                    </div>
                </div>
            </div>

            <!-- Vehicle Information -->
            <div class="preview-section">
                <h4 class="preview-heading">Vehicle Information</h4>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Make:</strong> <span class="preview-value" data-field="carMake"></span></p>
                        <p><strong>Model:</strong> <span class="preview-value" data-field="vehModel"></span></p>
                        <p><strong>Year of Make:</strong> <span class="preview-value" data-field="yearMake"></span></p>
                        <p><strong>Start Date:</strong> <span class="preview-value" data-field="startDate"></span></p>
                        <p><strong>Usage:</strong> <span class="preview-value" data-field="vehUsage"></span></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Registration No:</strong> <span class="preview-value" data-field="regNo"></span></p>
                        <p><strong>Engine No:</strong> <span class="preview-value" data-field="engNo"></span></p>
                        <p><strong>Chasis No:</strong> <span class="preview-value" data-field="chasis"></span></p>
                        <p><strong>Color:</strong> <span class="preview-value" data-field="color"></span></p>
                        @if ($type === 'thirdparty')
                            <p><strong>Vehicle Type:</strong> <span class="preview-value" data-field="vehType"></span></p>
                            <p><strong>Premium:</strong> <span class="preview-value" data-field="premium"></span></p>
                        @endif
                        
                    </div>
                </div>
            </div>

            <!-- Vehicle Value (Comprehensive only) -->
            <div class="preview-section comprehensive-only" style="display:none;">
                <h4 class="preview-heading">Vehicle Value</h4>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Vehicle Value:</strong> <span class="preview-value" data-field="vehValue"></span></p>
                        <p><strong>Excess Buy Back:</strong> <span class="preview-value" data-field="bback"></span></p>
                    </div>
                </div>
            </div>

            <!-- Policy Type (Enhanced only) -->
            <div class="preview-section enhance-only" style="display:none;">
                <h4 class="preview-heading">Policy Type</h4>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Policy Type:</strong> <span class="preview-value" data-field="policy_type"></span></p>
                    </div>
                </div>
            </div>

            <!-- Inspection Information (Comprehensive & Enhanced) -->
            <div class="preview-section inspection-only" style="display:none;">
                <h4 class="preview-heading">Inspection Information</h4>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>State:</strong> <span class="preview-value" data-field="ins_state"></span></p>
                        <p><strong>Address:</strong> <span class="preview-value" data-field="ins_address"></span></p>
                        <p><strong>Inspection Date:</strong> <span class="preview-value" data-field="ins_date"></span></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Contact Person:</strong> <span class="preview-value" data-field="ins_person"></span></p>
                        <p><strong>Contact Number:</strong> <span class="preview-value" data-field="ins_contact"></span></p>
                    </div>
                </div>
            </div>

            <!-- Bank Information -->
            <div class="preview-section">
                <h4 class="preview-heading">Bank Account Information</h4>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>BVN:</strong> <span class="preview-value" data-field="bvn"></span></p>
                        <p><strong>Account Number:</strong> <span class="preview-value" data-field="account_number"></span></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Bank Name:</strong> <span class="preview-value" data-field="bank_name"></span></p>
                        <p><strong>Account Type:</strong> <span class="preview-value" data-field="account_type"></span></p>
                    </div>
                </div>
            </div>

            <!-- Documents -->
            <div class="preview-section">
                <h4 class="preview-heading">Uploaded Documents</h4>
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Proof of Ownership:</strong> <span class="preview-value" data-field="doc_name"></span></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Valid ID:</strong> <span class="preview-value" data-field="doc_name_id"></span></p>
                    </div>
                </div>
            </div>

            <div class="text-center" style="margin-top: 30px;">
                <p style="color: #e74c3c; font-weight: bold;">Please review all information carefully. Click "Backward" to make changes or "Forward" to proceed.</p>
            </div>
        </div><!-- End col-md-12 -->
    </div><!-- End row -->


<style>
.preview-section {
    background: #f9f9f9;
    padding: 20px;
    margin-bottom: 20px;
    border-radius: 5px;
    border-left: 4px solid #a72118;
}

.preview-heading {
    color: #2c3e50;
    margin-bottom: 15px;
    font-size: 18px;
    font-weight: bold;
    border-bottom: 2px solid #a72118;
    padding-bottom: 10px;
}

.preview-section p {
    margin-bottom: 10px;
    line-height: 1.6;
}

.preview-section strong {
    color: #34495e;
    min-width: 150px;
    display: inline-block;
}

.preview-value {
    color: #2c3e50;
    font-weight: normal;
}
</style>



<script>
document.addEventListener('DOMContentLoaded', function() {
    const insuranceType = '{{ $type }}'; // Get the insurance type from PHP
    
    // Show/hide sections based on insurance type
    if (insuranceType === 'comprehensive') {
        document.querySelector('.comprehensive-only').style.display = 'block';
        document.querySelector('.inspection-only').style.display = 'block';
    } else if (insuranceType === 'enhance') {
        document.querySelector('.enhance-only').style.display = 'block';
        document.querySelector('.inspection-only').style.display = 'block';
    }
    
    // Hide vehType field for comprehensive
    if (insuranceType === 'comprehensive') {
        const vehTypeFields = document.querySelectorAll('.vehType-field');
        vehTypeFields.forEach(field => field.style.display = 'none');
    }

    // Function to populate preview
    function populatePreview() {
        const form = document.getElementById('wrapped');
        if (!form) return;
        
        const previewElements = document.querySelectorAll('.preview-value');
        
        previewElements.forEach(element => {
            const fieldName = element.getAttribute('data-field');
            let value = '';
            
            // Special handling for premium field (different IDs based on type)
            if (fieldName === 'premium') {
                const premiumInput = form.querySelector('#premium') || 
                                   form.querySelector('#thirdparty_premium') || 
                                   form.querySelector('#enhance_premium');
                if (premiumInput) {
                    value = premiumInput.value;
                }
            }
            // Handle radio buttons
            else if (fieldName === 'sex') {
                const radioInput = form.querySelector(`input[name="${fieldName}"]:checked`);
                value = radioInput ? radioInput.value : '';
            }
            // Handle file inputs
            else {
                const input = form.querySelector(`[name="${fieldName}"]`);
                if (input) {
                    if (input.type === 'file') {
                        value = input.files[0] ? input.files[0].name : 'No file selected';
                    } else if (input.tagName === 'SELECT') {
                        value = input.options[input.selectedIndex]?.text || input.value;
                    } else {
                        value = input.value;
                    }
                }
            }
            
            element.textContent = value || 'Not provided';
        });
    }

    // Detect when preview step becomes active
    // This works with most wizard libraries that add an "active" class
    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            const previewStep = document.querySelector('.step:has(.preview-section)');
            if (previewStep && (previewStep.classList.contains('active') || 
                                previewStep.style.display !== 'none')) {
                populatePreview();
            }
        });
    });

    // Start observing the form for changes
    const surveyContainer = document.getElementById('survey_container');
    if (surveyContainer) {
        observer.observe(surveyContainer, {
            attributes: true,
            attributeFilter: ['class', 'style'],
            subtree: true
        });
    }

    // Also listen for forward button clicks
    const forwardBtn = document.querySelector('button.forward');
    if (forwardBtn) {
        forwardBtn.addEventListener('click', function() {
            setTimeout(populatePreview, 200);
        });
    }

    // Populate immediately if we're already on the preview step
    setTimeout(populatePreview, 500);
});
</script>