<div class="row">
    <h3 class="col-md-10">Vehicle Value</h3>

    <div class="col-md-11">
        <ul class="data-list">
            <li>Cost Of Vehicle <input type="text" name="vehValue"
                    value="{{ old('vehValue', session('insurance_data.vehValue')) }}"
                    class="required form-control" placeholder="2,000,000"></li>

            <select class="form-control required" name="bback">
                <option value="">Excess Buy Back*</option>
                <option value="Yes">Yes</option>
                <option value="No">No</option>
            </select>

            <select class="form-control required" name="vehType"
                value="{{ old('vehType', session('insurance_data.vehType')) }}"
                id="vehType">
                <option value="" selected>Select Vehicle Type</option>
                @if ($vehicles->count() > 0)
                    @foreach ($vehicles as $car)
                        <option value="{{ $car->vehicle_type_name }}">
                            {{ $car->vehicle_type_name }}</option>
                    @endforeach
                @endif
            </select>

            <li>premium <input type="text" name="premium"
                    value="{{ old('premium', session('insurance_data.premium')) }}"
                    class="requireds form-control" id="premium" placeholder="Premium" readonly
                    style="background-color: #000; color: #fff;">
            </li>
        </ul>
    </div>

</div>
<!-- end step-->
<script>
    const vehicleTypes = @json($vehicles->pluck('premium_ratio', 'vehicle_type_name'));

    function calculatePremium() {
        let vehValue = $('input[name="vehValue"]').val().replace(/,/g, '');
        let vehType = $('#vehType').val();

        vehValue = parseFloat(vehValue);
        let ratio = parseFloat(vehicleTypes[vehType]);

        if (!isNaN(vehValue) && !isNaN(ratio)) {
            let premium = Math.ceil(vehValue * ratio);
            $('#premium').val(premium); // no comma formatting
        } else {
            $('#premium').val('');
        }
    }

    $(document).ready(function() {
        $('#vehType').on('change', calculatePremium);
        $('input[name="vehValue"]').on('input', calculatePremium);
    });
</script>