@extends('Layout.layout')

@section('content')
<style>
    .claim-section {
        padding: 60px 0;
        /* background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%); */
        min-height: 100vh;
    }
    
    .claim-container {
        background: white;
        border-radius: 15px;
        box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        overflow: hidden;
    }
    
    .claim-info {
        background: linear-gradient(135deg, #a72118 0%, #a72218d0 100%);
        color: white;
        padding: 50px 40px;
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }
    
    .claim-info h2 {
        font-size: 32px;
        font-weight: 700;
        margin-bottom: 30px;
        line-height: 1.3;
    }
    
    .claim-info p {
        font-size: 16px;
        line-height: 1.8;
        opacity: 0.95;
        margin-bottom: 20px;
    }
    
    .info-box {
        background: rgba(255,255,255,0.1);
        backdrop-filter: blur(10px);
        border-radius: 10px;
        padding: 25px;
        margin-top: 30px;
    }
    
    .info-box h4 {
        font-size: 18px;
        font-weight: 600;
        margin-bottom: 15px;
        display: flex;
        align-items: center;
    }
    
    .info-box h4 i {
        margin-right: 10px;
        font-size: 22px;
    }
    
    .info-list {
        list-style: none;
        padding: 0;
        margin: 15px 0 0 0;
    }
    
    .info-list li {
        padding: 8px 0;
        display: flex;
        align-items: center;
        font-size: 15px;
    }
    
    .info-list li:before {
        content: "✓";
        margin-right: 12px;
        font-weight: bold;
        color: #ff9;
        font-size: 18px;
    }
    
    .email-contact {
        background: rgba(255,255,255,0.15);
        padding: 20px;
        border-radius: 8px;
        margin-top: 20px;
        text-align: center;
    }
    
    .email-contact a {
        color: white;
        font-weight: 600;
        font-size: 16px;
        text-decoration: none;
        border-bottom: 2px solid rgba(255,255,255,0.5);
        padding-bottom: 2px;
    }
    
    .email-contact a:hover {
        border-bottom-color: white;
    }
    
    .claim-form {
        padding: 50px 40px;
    }
    
    .claim-form h3 {
        font-size: 28px;
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 10px;
    }
    
    .claim-form .subtitle {
        color: #6b7280;
        margin-bottom: 35px;
        font-size: 15px;
    }
    
    .form-group label {
        font-weight: 600;
        color: #374151;
        margin-bottom: 8px;
        font-size: 14px;
        display: block;
    }
    
    .form-control {
        height: 50px;
        border: 2px solid #e5e7eb;
        border-radius: 8px;
        padding: 12px 16px;
        font-size: 15px;
        transition: all 0.3s ease;
    }
    
    .form-control:focus {
        border-color: #a72118;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        outline: none;
    }
    
    textarea.form-control {
        height: 140px;
        resize: vertical;
    }
    
    .btn-submit {
        background: linear-gradient(135deg, #a72118 0%, #a72218c9 100%);
        color: white;
        border: none;
        padding: 15px 40px;
        font-size: 16px;
        font-weight: 600;
        border-radius: 8px;
        width: 100%;
        margin-top: 20px;
        cursor: pointer;
        transition: transform 0.2s ease, box-shadow 0.2s ease;
    }
    
    .btn-submit:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
    }
    
    .btn-submit:active {
        transform: translateY(0);
    }
    
    .alert {
        border-radius: 8px;
        padding: 15px 20px;
        margin-bottom: 25px;
        border: none;
    }
    
    .alert-success {
        background: #d1fae5;
        color: #333f2e;
    }
    
    .alert-danger {
        background: #fee2e2;
        color: #991b1b;
    }
    
    @media (max-width: 991px) {
        .claim-info {
            padding: 40px 30px;
        }
        
        .claim-form {
            padding: 40px 30px;
        }
    }
</style>

<section class="claim-section">
    <div class="container">
        <div class="claim-container">
            <div class="row no-gutters">
                <!-- Left: Information -->
                <div class="col-lg-5">
                    <div class="claim-info">
                        <h2>Claim Notification</h2>
                        <p>Submit your claim notification quickly and securely. Our team will process your request within 24-48 hours.</p>
                        
                        <div class="info-box">
                            <h4><i class="fa fa-file-text"></i> Required Information</h4>
                            <ul class="info-list">
                                <li>Full Name</li>
                                <li>Valid Policy Number</li>
                                <li>Detailed Incident Report</li>
                            </ul>
                        </div>
                        
                        <div class="email-contact">
                            <p style="margin-bottom: 10px; font-size: 14px; opacity: 0.9;">Or send directly to:</p>
                            <a href="mailto:motorclaim@nem-insurance.com">motorclaim@nem-insurance.com</a>
                        </div>
                    </div>
                </div>
                
                <!-- Right: Form -->
                <div class="col-lg-7">
                    <div class="claim-form">
                        <h3>Submit Your Claim</h3>
                        <p class="subtitle">Fill out the form below to notify us of your claim</p>
                        
                        @if (session('success'))
                            <div class="alert alert-success">
                                <strong>Success!</strong> {{ session('success') }}
                            </div>
                        @endif
                        
                        @if (session('error'))
                            <div class="alert alert-danger">
                                <strong>Error!</strong> {{ session('error') }}
                            </div>
                        @endif
                        
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <strong>Please fix the following errors:</strong>
                                <ul style="margin: 10px 0 0 0; padding-left: 20px;">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        
                        <form action="{{ route('insurance.claimStore') }}" method="POST">
                            @csrf
                            
                            <div class="form-group">
                                <label for="name">Full Name <span style="color: #ef4444;">*</span></label>
                                <input type="text" 
                                       class="form-control @error('name') is-invalid @enderror" 
                                       id="name" 
                                       name="name" 
                                       value="{{ old('name') }}" 
                                       placeholder="Enter your full name"
                                       required>
                            </div>
                            
                            <div class="form-group">
                                <label for="policy_number">Policy Number <span style="color: #ef4444;">*</span></label>
                                <input type="text" 
                                       class="form-control @error('policy_number') is-invalid @enderror" 
                                       id="policy_number" 
                                       name="policy_number" 
                                       value="{{ old('policy_number') }}" 
                                       placeholder="Enter your policy number"
                                       required>
                                <small class="form-text text-muted">Must be a valid policy number from our records</small>
                            </div>
                            
                            <div class="form-group">
                                <label for="incident_report">Incident Report <span style="color: #ef4444;">*</span></label>
                                <textarea class="form-control @error('incident_report') is-invalid @enderror" 
                                          id="incident_report" 
                                          name="incident_report" 
                                          placeholder="Describe the incident in detail..."
                                          required>{{ old('incident_report') }}</textarea>
                            </div>
                            
                            <button type="submit" class="btn-submit">
                                <i class="fa fa-paper-plane"></i> Submit Claim Notification
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection