<!DOCTYPE html>
<html>
<head>
    <style>
        * { font-family: "Times"; } 
        body {
  font-family: Arial, sans-serif;
  font-size: 13px;
  margin: 0;          /* ✅ Remove padding/margin for PDF */
  padding: 0;
  
  background: #f8f8f8;
}

#certificate {
  max-width: 800px;
  width: 100%;
  background: #fff;
  padding: 40px;       /* ✅ Controlled padding inside PDF */
  box-sizing: border-box;
  text-align: left;
  justify-content: center;
}
        .certificate {
            border: 4px solid #cc0000;
            padding: 30px 40px;
            background: #fff;
            max-width: 800px;
            margin: 0 auto;
            position: relative;
        }
        .header-section {
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: left;
        margin-bottom: 20px;
    }
        .text-center img.logo {
            margin-bottom: 10px;
            margin-right: 20px;
        }

        .header-section img{
            height: 70px !important;
        }
        .header-text {
            text-align: left;
            text-transform: uppercase;
            font-weight: bold;
            margin-top: 10px;
            margin-left: 20px;
        }
        .contact {
            text-align: left;
            font-size: 12px;
            margin-top: 5px;
            margin-left: 20px;
        }
        .title {
            text-align: center;
            font-weight: bold;
            text-transform: uppercase;
            margin: 20px 0 10px;
        }
        .info-box {
            border: 1px solid #000;
            padding: 5px 10px;
            margin-bottom: 15px;
            border-radius: 40px;
        }
        .info-row {
            margin-bottom: 8px;
        }
        .info-label {
            font-weight: bold;
        }
        ol {
            padding-left: 20px;
        }
        .footer-content{
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
        }
        .footer-content img {
            max-height: 60px;
        }
        .footer {
            text-align: left;
            font-style: italic;
            font-size: 12px;
            margin-top: 40px;
        }
        .bottom-section {
            margin-top: 40px;
        }
        .bottom-icons {
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
            margin-top: 20px;
        }
        .bottom-icons .left {
            text-align: left;
        }
        .bottom-icons .center {
            text-align: center;
        }
        .bottom-icons .right {
            text-align: right;
        }
        .bottom-icons img {
            max-height: 60px;
        }
        .auth-signature {
            font-weight: bold;
            margin-top: 5px;
        }

        .btn{background-color: #a72118 !important; border: #a72118 !important}

        .row {
        display: flex;
        flex-wrap: wrap;
    }



   
    </style>
</head>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>

<!-- Main Style -->
<link href="{{ asset('Assets/css/style.css') }}" rel="stylesheet">

<link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.0.1/css/bootstrap.min.css" rel="stylesheet">
<body>
    <div id="certificate">
        <div class="certificate">
            <div class="header-section">
            <img src="{{ asset('Assets/img/nem.jpg') }}" class="logo" alt="Logo">
            <div class="header-text-block">
                <div class="header-text">NEM Insurance PLC</div>
                <div class="contact">
                    <strong>HEAD OFFICE:</strong> 199, Ikorodu Road, Obanikoro-Lagos<br>
                    <strong>Tel:</strong> 01 4489560-9 <strong>Support Center:</strong> 01 4489570-2<br>
                <strong>Email:</strong>  nem@nem-insurance.com
                </div>
            </div>
        </div>
    
        <div class="title">{{ $ins_class }} Act, 1945<br>Certificate of Insurance</div>
    
        <div class="info-box">
            <div class="row">
                <div class="col-xs-6"><span class="info-label">Certificate no:</span> {{ $certNo }}</div>
                <div class="col-xs-6"><span class="info-label">Policy no:</span> {{ $policyID }}</div>
                <div class="col-xs-6"><span class="info-label">Naicom ID:</span> {{ $naicomPolicyID }}</div>
            </div>
        </div>
    
        <div class="row info-row">
            <div class="col-xs-6"><span class="info-label">Index mark and registration number of vehicle:</span> {{ $regNo }}</div>
            <div class="col-xs-6"><span class="info-label">Make:</span>  {{ $vehMake }}</div>
        </div>
        <div class="row info-row">
            <div class="col-xs-6"><span class="info-label">Name of Policy Holder:</span>  {{ $fullname }}</div>
            <div class="col-xs-6"><span class="info-label">Model:</span>  {{ $vehModel }}</div>
        </div>
        <div class="row info-row">
            <div class="col-xs-6"><span class="info-label">Effective date of the commencement of insurance for the purpose of the Act:</span> {{ $startDate }}</div>
            <div class="col-xs-6"><span class="info-label">Date of expiry of Insurance:</span>  {{ $endDate }}</div>
        </div>
    
        <p><strong>Persons or class persons Entitled to drive</strong></p>
        <ol>
            <li>The Policyholder. The Policyholder may also drive a private Motor Car (but not a Motor Cycle or Commercial vehicle or other mechanically propelled vehicle) not belonging to him and not hired to him under a hire purchase agreement.</li>
            <li>Any other person who is driving on the Policyholder's order or with his permission provided that the person driving is permitted in accordance with the licensing or other laws or regulation to drive the Motor Vehicle or has been so permitted and is not disqualified by order of a Court of Law or by reason of enactment or regulation in that behalf from driving such Motor Vehicle.</li>
        </ol>
    
        <p><strong>Limitation as to use</strong></p>
        <ol>
            <li>Use only for social domestic and pleasure purpose and for the Policyholder's business.</li>
            <li>The Policy does not cover use for hire or reward or for racing pace-making reliability trial speed testing or use for any purpose in connection with the Motor Trade.</li>
        </ol>
    
        <div class="bottom-section">
            <p><strong>I/We hereby Certify that the policy to which this certification relates is issued in accordance with the provision of the motor vehicles. (Third party Insurance) Act 1945;</strong></p>
    
            <div class="bottom-icons">
                <div class="left">
                    <img src="{{ asset('Assets/img/nem.jpg') }}" alt="NEM Stamp">
                </div>
                <div class="center">
                    <img src="{{ asset('Assets/img/nem.jpg') }}" alt="Signature"><br>
                    <span class="auth-signature">Authorized Signatory</span>
                </div>
                
            </div>
            <div class="footer-content">
                <div class="footer">
                    To verify the validity of your insurance, SMS: Policy No. *Plate No. to 33215 or visit:<br>
                    www.askniid.org<br><br>
                    Authorized and Regulated by the National Insurance Commission RIC No. 028 (G)
                </div>

                <div class="right">
                    <img src="{{ asset('Assets/img/nem.jpg') }}" alt="NIID Logo">
                </div>

            </div>
            
        </div>
        </div>
    </div>
    <!-- Download Button -->
<div class="text-center" style="margin-top: 30px;">
    <button onclick="downloadCertificate()" class="btn btn-success">Download Certificate</button>
</div>
{{-- {{ route("certificate.downloaded", ["vehicle_id" => $transaction->vehicle->id]) }} --}}

  


  <!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Bootstrap JS (required for modal) -->
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.0.1/js/bootstrap.min.js"></script>

<script>
    function downloadCertificate() {
    const element = document.getElementById('certificate');
    const opt = {
        margin: 0,  // ✅ no margin – let the #certificate padding handle spacing
        filename: 'mtp-insurance-certificate.pdf',
        image: { type: 'jpeg', quality: 1 },
        html2canvas: {
            scale: 3,           // ✅ sharp quality
            useCORS: true,
            scrollY: 0,         // ✅ prevent scroll issues
        },
        jsPDF: {
            unit: 'px',         // ✅ pixel-perfect PDF
            format: [700, 1100], // ✅ custom paper size
            orientation: 'portrait'
        }
    };

    html2pdf().set(opt).from(element).save().then(() => {
        fetch('{{ route("certificate.downloaded", ["vehicle_id" => $transaction->vehicle->id]) }}', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({})
        })
        .then(response => response.json())
        .then(data => {
            if (data.status) {
                console.log("Certificate status updated.");
            } else {
                console.error("Failed to update certificate status.");
            }
        })
        .catch(err => {
            console.error("Error updating certificate:", err);
        });
    });
}

</script>

</body>
</html>
