@extends('Layout.admin-dash')
@section('content')
    <div class="main-content">
        <div class="section__content statistic2 section__content--p30">
            <div class="container">

                <div class="row">
                    <div class="col-lg-12">
                        <h3 class="title-5 m-b-35">Policies History</h3>
                        <div class="table-data__tool">
                            <div class="table-data__tool-left">
                                <div class="rs-select2--light rs-select2--md">
                                    <select class="js-select2" name="property">
                                        <option selected="selected">All</option>
                                        <option value="">Motor Third Party</option>
                                        <option value="">Comprehensive</option>
                                    </select>
                                    <div class="dropDownSelect2"></div>
                                </div>
                                <div class="rs-select2--light rs-select2--sm">
                                    <select class="js-select2" name="time">
                                        <option selected="selected">Today</option>
                                        <option value="">This Week</option>
                                        <option value="">This Month</option>
                                    </select>
                                    <div class="dropDownSelect2"></div>
                                </div>
                                <button class="au-btn-filter">
                                    <i class="zmdi zmdi-filter-list"></i>filters</button>
                            </div>
                            <div class="table-data__tool-right">
                               <form action="#">
                                @csrf
                                <div class="input-group">
                                    <input type="text" id="input3-group2" name="input3-group2" placeholder="Search" class="form-control">
                                    <div class="input-group-btn">
                                        <button class="btn btn-primary">
                                            <i class="zmdi zmdi-search"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                               </form>
                            
                        </div>
                        <div class="table-responsive table-responsive-data2">
                            <table class="table table-data2">
                                <thead>
                                    <tr>
                                        <th>Insurance Class</th>
                                        <th>Client Name</th>
                                        <th>RegNo</th>
                                        <th>PolicyNo</th>
                                        <th>Premium</th>
                                        <th>startDate</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if ($vehicles->count() > 0)
                                        @foreach ($vehicles as $data)
                                            <tr class="tr-shadow">

                                                <td> {{ $data->ins_class }}</td>
                                                <td>
                                                    <span class="block-email">{{ $data->customer->fname }} {{ $data->customer->lname }}</span>
                                                </td>
                                                <td class="desc">{{ $data->regNo }}</td>
                                                <td class="desc">{{ $data->policy_no }}</td>
                                                <td>{{ $data->premium }}</td>
                                                <td>{{ $data->startDate }}</td>
                                                <td>
                                                    <div class="table-data-feature">

                                                        <button class="item" data-toggle="modal"
                                                            data-target="#viewModal-{{ $data->id }}"
                                                            data-placement="top" title="View Info">
                                                            <i class="zmdi zmdi-eye"></i>
                                                        </button>
                                                    </div>

                                                </td>
                                            </tr>
                                         @endforeach
                                         @else
                                         <tr>
                                            <td colspan="5" class="text-center">No Vehicle data found</td>
                                        </tr>
                                    @endif

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



     <!-- modal medium view -->
     <div class="main-content">
        @foreach ($vehicles as $data)
            <div class="modal fade" id="viewModal-{{ $data->id }}" tabindex="-1" role="dialog"
                aria-labelledby="mediumModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="mediumModalLabel">{{ $data->customer->fname }}
                                {{ $data->customer->lname }}</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <div class="modal-body">
                            <div class="col-lg-12">

                                <div class="container mt-4">
                                    <h5 class="text-uppercase font-weight-bold border-bottom pb-2"> Personal Information
                                    </h5>

                                    <table class="table table-bordered">
                                        <tbody>
                                            <tr>
                                                <th>Title</th>
                                                <td>{{ $data->customer->title ?? '-' }}</td>
                                            </tr>

                                            <tr>
                                                <th>Customer</th>
                                                <td>{{ $data->customer->fname ?? '-' }} {{ $data->customer->lname ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Residential Address</th>
                                                <td>{{ $data->customer->address ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Phone Number</th>
                                                <td>{{ $data->customer->phone_no ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Email</th>
                                                <td>{{ $data->customer->email ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Occupation</th>
                                                <td>{{ $data->customer->job ?? '-' }}</td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <h5 class="text-uppercase font-weight-bold border-bottom"
                                        style="margin-top: 20px; margin-bottom: 20px; text-align:center;"> Vehicle
                                        Information
                                    </h5>

                                    <table class="table table-bordered">
                                        <tbody>
                                            
                                            <tr>
                                                <th>Insurance Class</th>
                                                <td>{{ $data->ins_class ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Vehicle Value</th>
                                                <td>{{ $data->vehValue ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Vehicle Model</th>
                                                <td>{{ $data->vehModel ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Registration Number</th>
                                                <td>{{ $data->regNo ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Engine Number</th>
                                                <td>{{ $data->engNo ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Chassis</th>
                                                <td>{{ $data->chasis ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Color</th>
                                                <td>{{ $data->color ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Vehicle Type</th>
                                                <td>{{ $data->vehType ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Vehicle Usage</th>
                                                <td>{{ $data->vehUsage ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Transaction Reference</th>
                                                <td>{{ $data->tnx_ref ?? '-' }}</td>
                                            </tr>
                                            @if (!empty($data->premiumCharged))
                                            <tr>
                                                <th>Date</th>
                                                <td>{{ $data->date ?? '-' }}</td>
                                            </tr>
                                            @endif
                                            <tr>
                                                <th>Status</th>
                                                <td>{{ $data->status ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Policy Number</th>
                                                <td>{{ $data->policy_no ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Certificate Number</th>
                                                <td>{{ $data->cert_no ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Start Date</th>
                                                <td>{{ $data->startDate ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>End Date</th>
                                                <td>{{ $data->endDate ?? '-' }}</td>
                                            </tr>

                                            @if (!empty($data->referral_code))
                                            <tr>
                                                <th>Referrer Code</th>
                                                <td>{{ $data->referral_code ?? '-' }}</td>
                                            </tr>
                                            @endif

                                            <tr>
                                                <th>Sale Type</th>
                                                <td>{{ $data->sale_type ?? '-' }}</td>
                                            </tr>

                                            <tr>
                                                <th>Year Make</th>
                                                <td>{{ $data->yearMake ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Premium</th>
                                                <td>{{ $data->premium ?? '-' }}</td>
                                            </tr>

                                            @if (!empty($data->referral_code))
                                            <tr>
                                                <th>Buy Back</th>
                                                <td>{{ $data->bback ?? '-' }}</td>
                                            </tr>
                                            @endif
                                        </tbody>
                                    </table>

                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        @endforeach
        <!-- end view modal medium -->
    </div>
@endsection
