@extends('Layout.admin-dash')
@section('content')
    <div class="main-content">
        <div class="section__content statistic2 section__content--p30">
            <div class="container">

                <div class="row">
                    <div class="col-lg-12">
                        <h3 class="title-5 m-b-35">Transaction History</h3>
                        <div class="table-data__tool">
                            <div class="table-data__tool-left">
                                <div class="rs-select2--light rs-select2--md">
                                    <select class="js-select2" name="property" id="propertyFilter">
                                        <option value="">All Properties</option>
                                        <option value="Motor Third Party Insurance">Motor Third Party Insurance</option>
                                        <option value="Comprehensive Motor Third Party Insurance">Comprehensive Motor Third Party Insurance</option>
                                    </select>
                                    <div class="dropDownSelect2"></div>
                                </div>
                                <div class="rs-select2--light rs-select2--sm">
                                    <select class="js-select2" name="time" id="timeFilter">
                                        <option value="">All Time</option>
                                        <option value="Today">Today</option>
                                        <option value="This Week">This Week</option>
                                        <option value="This Month">This Month</option>
                                    </select>
                                    <div class="dropDownSelect2"></div>
                                </div>
                                <button class="au-btn-filter">
                                    <i class="zmdi zmdi-filter-list"></i>filters</button>
                            </div>
                            <div class="table-data__tool-right">
                               <form action="#" style="display: inline-block;">
                                @csrf
                                <div class="input-group">
                                    <input type="text" id="searchInput" name="input3-group2" placeholder="Search" class="form-control">
                                    <div class="input-group-btn">
                                        <button class="btn btn-primary" type="button">
                                            <i class="zmdi zmdi-search"></i>
                                        </button>
                                    </div>
                                </div>
                               </form>
                               
                               <!-- Export Buttons -->
                               <div class="btn-group mt-2" role="group">
                                    <button type="button" class="btn btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <i class="zmdi zmdi-download"></i> Export
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right">
                                        <a class="dropdown-item" href="#" onclick="exportData('excel'); return false;">
                                            <i class="zmdi zmdi-file-text"></i> Export to Excel
                                        </a>
                                        <a class="dropdown-item" href="#" onclick="exportData('csv'); return false;">
                                            <i class="zmdi zmdi-file"></i> Export to CSV
                                        </a>
                                        <a class="dropdown-item" href="#" onclick="exportData('pdf'); return false;">
                                            <i class="zmdi zmdi-collection-pdf"></i> Export to PDF
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive table-responsive-data2">
                            <table class="table table-data2">
                                <thead>
                                    <tr>
                                        <th>Customer Name</th>
                                        <th>Amount</th>
                                        <th>serialNo</th>
                                        <th>Policy-Type</th>
                                        <th>Transaction Reference</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if ($transactions->count() > 0)
                                        @foreach ($transactions as $data)
                                            <tr class="tr-shadow">

                                                <td>{{ $data->vehicle->customer->fname }} {{ $data->vehicle->customer->lname }}</td>
                                                <td>
                                                    <span class="block-email">{{ number_format($data->amount, 2) }}</span>
                                                </td>
                                                <td class="desc">{{ $data->serialNo }}</td>
                                                <td>{{ $data->vehicle->vehType }}</td>
                                                <td>{{ $data->tnx_ref }}</td>
                                                <td>
                                                    <div class="table-data-feature">
                                                        
                                                        <button class="item" data-toggle="modal"
                                                        data-target="#viewModal-{{ $data->id }}"
                                                        data-placement="top" title="View Info">
                                                        <i class="zmdi zmdi-eye"></i>
                                                    </button>
                                                    </div>
                                                </td>
                                            </tr>
                                         @endforeach
                                         @else
                                         <tr>
                                            <td colspan="6" class="text-center">No Transaction data found</td>
                                        </tr>
                                    @endif

                                </tbody>
                            </table>
                        </div>
                        
                        @if ($transactions->count() > 0)
                        <div class="mt-3">
                            <strong>Total Records:</strong> {{ $transactions->count() }} | 
                            <strong>Total Amount:</strong> {{ number_format($transactions->sum('amount'), 2) }}
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>




    <!-- modal medium view -->
    <div class="main-content">
        @foreach ($transactions as $data)
            <div class="modal fade" id="viewModal-{{ $data->id }}" tabindex="-1" role="dialog"
                aria-labelledby="mediumModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="mediumModalLabel">{{ $data->vehicle->customer->fname }}
                                {{ $data->vehicle->customer->lname }}</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <div class="modal-body">
                            <div class="col-lg-12">

                                <div class="container mt-4">
                                    <h5 class="text-uppercase font-weight-bold border-bottom pb-2"> Personal Information
                                    </h5>

                                    <table class="table table-bordered">
                                        <tbody>
                                            <tr>
                                                <th>Title</th>
                                                <td>{{ $data->vehicle->customer->title ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>First Name</th>
                                                <td>{{ $data->vehicle->customer->fname ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Last Name</th>
                                                <td>{{ $data->vehicle->customer->lname ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Residential Address</th>
                                                <td>{{ $data->vehicle->customer->address ?? '-' }}</td>
                                            </tr>

                                            <tr>
                                                <th>Phone Number</th>
                                                <td>{{ $data->vehicle->customer->phone_no ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Email</th>
                                                <td>{{ $data->vehicle->customer->email ?? '-' }}</td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <h5 class="text-uppercase font-weight-bold border-bottom"
                                        style="margin-top: 20px; margin-bottom: 20px; text-align:center;"> Transaction
                                        Information
                                    </h5>

                                    <table class="table table-bordered">
                                        <tbody>
                                            <tr>
                                                <th>Amount</th>
                                                <td>{{ $data->amount ?? '-' }}</td>
                                            </tr>

                                            @if (!empty($data->premiumCharged))
                                                <tr>
                                                    <th>Premium Charged</th>
                                                    <td>{{ $data->premiumCharged }}</td>
                                                </tr>
                                            @endif

                                            <tr>
                                                <th>Transaction Reference</th>
                                                <td>{{ $data->tnx_ref ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Date</th>
                                                <td>{{ $data->date ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Start Date</th>
                                                <td>{{ $data->start_date ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>End Date</th>
                                                <td>{{ $data->end_date ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Payment Method</th>
                                                <td>{{ $data->pay_method ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Status</th>
                                                <td>{{ $data->status ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Type</th>
                                                <td>{{ $data->type ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Serial Number</th>
                                                <td>{{ $data->serialNo ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Insu Class </th>
                                                <td>{{ $data->vehicle->ins_class ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Transaction Type</th>
                                                <td>{{ $data->trans_type ?? '-' }}</td>
                                            </tr>
                                            @if (!empty($data->referral_code))
                                                <tr>
                                                    <th>Referral Code</th>
                                                    <td>{{ $data->referral_code }}</td>
                                                </tr>
                                            @endif


                                            <tr>
                                                <th>Expiry</th>
                                                <td>{{ $data->expiry ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Policy Number</th>
                                                <td>{{ $data->policy_no ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Certificate NO</th>
                                                <td>{{ $data->cert_no ?? '-' }}</td>
                                            </tr>
                                        </tbody>
                                    </table>

                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        @endforeach
        <!-- end view modal medium -->
    </div>

    <script>
        function exportData(format) {
            // Get filter values
            const property = document.getElementById('propertyFilter').value;
            const time = document.getElementById('timeFilter').value;
            const search = document.getElementById('searchInput').value;
            
            // Build URL with query parameters
            let url = '';
            if (format === 'excel') {
                url = '{{ route("transactions.export.excel") }}';
            } else if (format === 'csv') {
                url = '{{ route("transactions.export.csv") }}';
            } else if (format === 'pdf') {
                url = '{{ route("transactions.export.pdf") }}';
            }
            
            // Add query parameters
            const params = new URLSearchParams();
            if (property) params.append('property', property);
            if (time) params.append('time', time);
            if (search) params.append('search', search);
            
            const queryString = params.toString();
            if (queryString) {
                url += '?' + queryString;
            }
            
            // Open in new window for PDF, download for others
            if (format === 'pdf') {
                window.open(url, '_blank');
            } else {
                window.location.href = url;
            }
        }
    </script>
@endsection