<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Transaction History</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            margin: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .header-info {
            margin: 20px 0;
            padding: 10px;
            background-color: #f5f5f5;
            border-left: 4px solid #4CAF50;
        }
        .header-info p {
            margin: 5px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            word-wrap: break-word;
        }
        th {
            background-color: #4CAF50;
            color: white;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Transaction History Report</h1>
    </div>

    <div class="header-info">
        <p><strong>Generated On:</strong> {{ date('F d, Y H:i:s') }}</p>
        <p><strong>Total Transactions:</strong> {{ $transactions->count() }}</p>
        <p><strong>Total Amount:</strong> {{ number_format($transactions->sum('amount'), 2) }}</p>
    </div>

    <div class="no-print" style="margin-bottom: 20px;">
        <button onclick="window.print()" style="padding: 10px 20px; background-color: #4CAF50; color: white; border: none; cursor: pointer; border-radius: 4px;">
            Print / Save as PDF
        </button>
        <button onclick="window.close()" style="padding: 10px 20px; background-color: #f44336; color: white; border: none; cursor: pointer; border-radius: 4px; margin-left: 10px;">
            Close
        </button>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 5%;">#</th>
                <th style="width: 15%;">Customer Name</th>
                <th style="width: 10%;">Amount</th>
                <th style="width: 12%;">Serial No</th>
                <th style="width: 15%;">Policy Type</th>
                <th style="width: 15%;">Transaction Ref</th>
                <th style="width: 10%;">Date</th>
                <th style="width: 8%;">Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($transactions as $index => $data)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $data->vehicle->customer->fname }} {{ $data->vehicle->customer->lname }}</td>
                <td>{{ number_format($data->amount, 2) }}</td>
                <td>{{ $data->serialNo }}</td>
                <td>{{ $data->vehicle->vehType }}</td>
                <td>{{ $data->tnx_ref }}</td>
                <td>{{ $data->date }}</td>
                <td>{{ $data->status }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <p>This is a computer-generated document. No signature is required.</p>
        <p>&copy; {{ date('Y') }} Your Company Name. All rights reserved.</p>
    </div>

    <script>
        // Auto print dialog on load (optional)
        // window.onload = function() { window.print(); }
    </script>
</body>
</html>