@extends('Layout.admin-dash')

@section('content')
    <div class="main-content">
        <div class="section__content statistic2 section__content--p30">
            <div class="container">

                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show mt-2" role="alert">
                        {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if (session('info'))
                    <div class="alert alert-info alert-dismissible fade show mt-2" role="alert">
                        {{ session('info') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible fade show mt-2" role="alert">
                        {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                <div class="row">
                    <div class="col-lg-12">
                        <h3 class="title-5 m-b-35">NIID/NAICON RESPONSES History</h3>

                        <div class="table-data__tool">
                            <div class="table-data__tool-left">
                                <div class="rs-select2--light rs-select2--md">
                                    <select class="js-select2" name="property">
                                        <option selected="selected">All</option>
                                        <option value="">Motor Third Party</option>
                                        <option value="">Comprehensive</option>
                                    </select>
                                    <div class="dropDownSelect2"></div>
                                </div>
                                <div class="rs-select2--light rs-select2--sm">
                                    <select class="js-select2" name="time">
                                        <option selected="selected">Today</option>
                                        <option value="">This Week</option>
                                        <option value="">This Month</option>
                                    </select>
                                    <div class="dropDownSelect2"></div>
                                </div>
                                <button class="au-btn-filter">
                                    <i class="zmdi zmdi-filter-list"></i>filters
                                </button>
                            </div>
                            <div class="table-data__tool-right">
                                <form action="#" method="GET">
                                    @csrf
                                    <div class="input-group">
                                        <input type="text" id="input3-group2" name="input3-group2" placeholder="Search"
                                            class="form-control">
                                        <div class="input-group-btn">
                                            <button class="btn btn-primary">
                                                <i class="zmdi zmdi-search"></i>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <div class="table-responsive table-responsive-data2">
                            <table class="table table-data2">
                                <thead>
                                    <tr>
                                        <th>Insurance Class</th>
                                        <th>Client Name</th>
                                        <th>NIID Response</th>
                                        <th>Policy No</th>
                                        <th>NAICON ID</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if ($vehicles->count() > 0)
                                        @foreach ($vehicles as $vehicle)
                                            <tr class="tr-shadow">
                                                <td>{{ $vehicle->ins_class }}</td>

                                                <td>
                                                    <span class="block-email">
                                                        {{ $vehicle->customer->fname ?? '' }}
                                                        {{ $vehicle->customer->lname ?? '' }}
                                                    </span>
                                                </td>

                                                <td>


                                                    @if (!empty($vehicle->niid_resp))
                                                        <span class="badge badge-success">NIID PASS</span>
                                                    @else
                                                        <span class="badge badge-danger">NIID Missing</span>
                                                    @endif
                                                </td>

                                                <td>{{ $vehicle->policy_no }}</td>

                                                <td>

                                                    @if (!empty($vehicle->naicom_unique_id))
                                                        <span
                                                            class="badge badge-info">{{ $vehicle->naicom_unique_id }}</span>
                                                    @else
                                                        <span class="badge badge-danger">NAICOM Missing</span>
                                                    @endif
                                                </td>

                                                <td>
                                                    {{-- Show Repush button if NIID or NAICON is missing --}}

                                                    @if (empty($vehicle->niid_resp) || empty($vehicle->naicom_unique_id))
                                                        <form action="{{ route('vehicle.repush', $vehicle->id) }}"
                                                            method="POST" style="display:inline;">
                                                            @csrf
                                                            <button type="submit" class="btn btn-primary btn-sm">
                                                                Repush to Missing Systems
                                                            </button>
                                                        </form>
                                                    @else
                                                        <span class="text-success">✔ Fully Synced</span>
                                                    @endif

                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="6" class="text-center">No response data found</td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
