@extends('Layout.admin-dash')

@section('content')
    
<div class="page-content--bge5">
    <div class="container">
         {{-- Validation Errors --}}
         @if ($errors->any())
         <div class="alert alert-danger alert-dismissible" role="alert">
             <strong>Error!</strong> Please check the following:
             <ul class="list-unstyled">
                 @foreach ($errors->all() as $error)
                     <li><span class="glyphicon glyphicon-remove-sign"></span> {{ $error }}</li>
                 @endforeach
             </ul>
         </div>
     @endif

     {{-- Success Message --}}
     @if (session('success'))
         <div class="alert alert-success alert-dismissible" role="alert">
             <strong>Success!</strong> {{ session('success') }}
         </div>
     @endif

     {{-- Error Message --}}
     @if (session('error'))
         <div class="alert alert-danger alert-dismissible" role="alert">
             <strong>Error!</strong> {{ session('error') }}
         </div>
     @endif
     
        <div class="login-wrap">
            <div class="login-content">
                <div class="login-logo">
                    <a href="#">
                        <img src="{{ url('Assets/img/nem.jpg') }}" alt="CoolAdmin">
                    </a>
                </div>
                <div class="login-form">
                    <form action="{{ route('admin.account') }}" method="post">
                        @csrf
                        <div class="form-group">
                            <label>Email Address</label>
                            <input class="au-input au-input--full" type="email" name="email" placeholder="Email">
                        </div>
                        <div class="form-group">
                            <label>Password</label>
                            <input class="au-input au-input--full" type="password" name="password" placeholder="Password">
                        </div>
                        <div class="login-checkbox">
                            <label>
                                <input type="checkbox" name="remember">Remember Me
                            </label>
                            <label>
                                <a href="#">Forgotten Password?</a>
                            </label>
                        </div>
                        <button class="au-btn au-btn--block au-btn--green m-b-20" type="submit">Sign in</button>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

@endsection