@extends('Layout.admin-dash')
@section('content')
    <div class="main-content">

        <div class="section__content statistic2 section__content--p30">

             {{-- Validation Errors --}}
             @if ($errors->any())
             <div class="alert alert-danger alert-dismissible" role="alert">
                 <strong>Error!</strong> Please check the following:
                 <ul class="list-unstyled">
                     @foreach ($errors->all() as $error)
                         <li><span class="glyphicon glyphicon-remove-sign"></span> {{ $error }}</li>
                     @endforeach
                 </ul>
             </div>
         @endif

         {{-- Success Message --}}
         @if (session('success'))
             <div class="alert alert-success alert-dismissible" role="alert">
                 <strong>Success!</strong> {{ session('success') }}
             </div>
         @endif

         {{-- Error Message --}}
         @if (session('error'))
             <div class="alert alert-danger alert-dismissible" role="alert">
                 <strong>Error!</strong> {{ session('error') }}
             </div>
         @endif
            <div class="container">

                <div class="row">
                    <div class="col-lg-12">
                        <h3 class="title-5 m-b-35">Inspection History</h3>
                        <div class="table-data__tool">
                            <div class="table-data__tool-left">
                                <div class="rs-select2--light rs-select2--md">
                                    <select class="js-select2" name="property">
                                        <option selected="selected">All Properties</option>
                                        <option value="">Motor Third Party Insurance</option>
                                        <option value="">Comprehensive Motor Third Party Insurance</option>
                                    </select>
                                    <div class="dropDownSelect2"></div>
                                </div>
                                <div class="rs-select2--light rs-select2--sm">
                                    <select class="js-select2" name="time">
                                        <option selected="selected">Today</option>
                                        <option value="">This Week</option>
                                        <option value="">This Month</option>
                                    </select>
                                    <div class="dropDownSelect2"></div>
                                </div>
                                <button class="au-btn-filter">
                                    <i class="zmdi zmdi-filter-list"></i>filters</button>
                            </div>
                            <div class="table-data__tool-right">
                               <form action="#">
                                @csrf
                                <div class="input-group">
                                    <input type="text" id="input3-group2" name="input3-group2" placeholder="Search" class="form-control">
                                    <div class="input-group-btn">
                                        <button class="btn btn-primary">
                                            <i class="zmdi zmdi-search"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                               </form>
                            
                        </div>
                        <div class="table-responsive table-responsive-data2">
                            <table class="table table-data2">
                                <thead>
                                    <tr>
                                        <th>Ins-Person</th>
                                        <th>Ins-Contact</th>
                                        <th>Inspection Address</th>
                                        <th>Insu-Class</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if ($inspect->count() > 0)
                                        @foreach ($inspect as $data)
                                            <tr class="tr-shadow">

                                                <td>{{ $data->ins_person }}</td>
                                                <td class="desc">{{ $data->ins_contact }}</td>
                                                <td>
                                                    <span class="block-email">{{ $data->ins_address }}</span>
                                                </td>
                                                <td>{{ $data->vehicle->ins_class }}</td>
                                                <td>
                                                    <div class="table-data-feature">
                                                        <button class="item" data-toggle="modal" data-placement="top" data-target="#mediumModal-{{ $data->id }}"
                                                            title="Edit">
                                                            <i class="zmdi zmdi-edit"></i>
                                                        </button>
                                                        
                                                        {{-- <button class="item" data-toggle="tooltip" data-placement="top"
                                                            title="Delete">
                                                            <i class="zmdi zmdi-delete"></i>
                                                        </button> --}}
                                                        <button class="item" data-toggle="tooltip" data-placement="top"
                                                            title="View Info">
                                                            <i class="zmdi zmdi-eye"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                         @endforeach
                                         @else
                                         <tr>
                                            <td colspan="5" class="text-center">No Customer data found</td>
                                        </tr>
                                    @endif


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>






    <!-- modal medium -->
        <div class="main-content">
            @foreach ($inspect as $data)
			<div class="modal fade" id="mediumModal-{{ $data->id }}" tabindex="-1" role="dialog" aria-labelledby="mediumModalLabel" aria-hidden="true">
				<div class="modal-dialog modal-lg" role="document">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title" id="mediumModalLabel">{{ $data->fname }} {{ $data->lname }}</h5>
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">
							<div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">Edit Information</div>
                                    <div class="card-body card-block">
                                        <form action="{{ route('inspect.inspectUpdate') }}" method="post">
                                            @csrf
                                             @method('PUT')
                                            <input type="hidden" name="id" value="{{ $data->id }}">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-addon">Inspection Proof</div>
                                                    <input type="file" id="proof" name="proof" value="{{ $data->proof }}" class="form-control">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-file"></i>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-addon">Physical Check</div>
                                                    <input type="text" id="physical_check" name="physical_check" value="{{ $data->physical_check }}" class="form-control">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-map"></i>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-addon">Inspection Status</div>
                                                    <input type="text" id="status" name="status" value="{{ $data->status }}" class="form-control">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-eye"></i>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row form-group">
                                                <div class="col col-md-2">
                                                    <label for="textarea-input" class=" form-control-label">Inspection Report</label>
                                                </div>
                                                <div class="col-12 col-md-10">
                                                    <textarea name="report" id="report" rows="9" placeholder="Report..." class="form-control">{{ $data->report }}</textarea>
                                                </div>
                                            </div>

                                            

                                            

                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                <button type="submit" class="btn btn-primary">Confirm Change</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
						</div>
						
					</div>
				</div>
			</div>
            @endforeach
			<!-- end modal medium -->
        </div>

@endsection
