@extends('Layout.admin-dash')

@section('content')


    <!-- MAIN CONTENT-->
    <div class="main-content">
        <div class="section__content statistic2 section__content--p30">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="overview-wrap">
                            <h2 class="title-1">overview</h2>
                            
                        </div>
                    </div>
                </div>
                <div class="row m-t-25">
                    <div class="col-md-6 col-lg-3">
                        <div class="statistic__item statistic__item--green">
                            <h2 class="number">{{ $total_user }}</h2>
                            <span class="desc">Total Customer</span>
                            <div class="icon">
                                <i class="zmdi zmdi-account-o"></i>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-6 col-lg-3">
                        <div class="statistic__item statistic__item--orange">
                            <h2 class="number">{{ $total_policy }}</h2>
                            <span class="desc">Total Policy Buy</span>
                            <div class="icon">
                                <i class="zmdi zmdi-shopping-cart"></i>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 col-lg-3">
                        <div class="statistic__item statistic__item--blue">
                            <h2 class="number">{{ $total_transaction }}</h2>
                            <span class="desc">Total Transaction</span>
                            <div class="icon">
                                <i class="zmdi zmdi-calendar-note"></i>
                            </div>
                        </div>
                    </div>



                    <div class="col-md-6 col-lg-3">
                        <div class="statistic__item statistic__item--green">
                            <h2 class="number">₦{{ $total_income }}</h2>
                            <span class="desc">total Income</span>
                            <div class="icon">
                                <i class="zmdi zmdi-money"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <h2 class="title-1 m-b-25">Customers Product</h2>
                        <div class="table-responsive table--no-card m-b-40">
                            <table class="table table-borderless table-striped table-earning">
                                <thead>
                                    <tr>
                                        <th class="text-right">Insurance Class</th>
                                        <th>Start Date</th>
                                        <th>Policy No</th>
                                        <th>Owners name</th>
                                        <th class="text-right">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @if ($vehicle->count() > 0)
                                        @foreach ($vehicle as $data)
                                            <tr>
                                                <td>{{ $data->ins_class }}</td>
                                                <td>{{ $data->startDate }}</td>
                                                    <td>{{ $data->policy_no }}</td>
                                                    <td>{{ $data->customer->fname }} {{ $data->customer->lname }}</td>
                                                <td class="text-right">
                                                    ₦{{ number_format($data->transaction->amount ?? 0, 2) }}</td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="5" class="text-center">No data found</td>
                                        </tr>
                                    @endif


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <h2 class="title-1 m-b-25">Transaction History</h2>
                        <div class="table-responsive table--no-card m-b-40">
                            <table class="table table-borderless table-striped table-earning">
                                <thead>
                                    <tr>
                                        <th class="text-right">Insurance Class</th>
                                        <th>Serial No</th>
                                        <th>Transaction Date</th>
                                        <th>Owners name</th>
                                        <th class="text-right">Status</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @if ($transactions->count() > 0)
                                        @foreach ($transactions as $data)
                                            <tr>
                                                <td>{{ $data->vehicle->ins_class }}</td>
                                                    <td>{{ $data->serialNo }}</td>
                                                    <td>{{ \Carbon\Carbon::parse($data->created_at)->format('m/d/y') }}</td>
                                                    <td>{{ $data->vehicle->customer->fname }} {{ $data->vehicle->customer->lname }}</td>
                                                <td class="text-right">
                                                    {{ $data->status }}</td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="5" class="text-center">No Transaction data found</td>
                                        </tr>
                                    @endif


                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="copyright">
                            <p>Copyright © 2018 Freemium. All rights reserved. Template by <a href="#">Freemium</a>.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END MAIN CONTENT-->
    <!-- END PAGE CONTAINER-->



    <div class="modal fade" id="addAdminModal" tabindex="-1" role="dialog" aria-labelledby="addAdminModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="addAdminModalLabel">
                    <i class="fas fa-user-shield"></i> Add New Admin User
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <form action="{{ route('admin.addUser') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <!-- Basic Info -->
                    <div class="mb-3">
                        <label class="form-label">Full Name</label>
                        <input type="text" name="name" class="form-control" placeholder="Enter full name" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Email Address</label>
                        <input type="email" name="email" class="form-control" placeholder="Enter email" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Password</label>
                        <input type="password" name="password" class="form-control" placeholder="Enter password" required>
                    </div>

                    <!-- Role Selection -->
                    <div class="mb-3">
                        <label class="form-label">Select Role</label>
                        <select class="form-select" name="role" required>
                            <option value="">-- Choose Role --</option>
                            <option value="super_admin">Super Admin</option>
                            <option value="manager">Manager</option>
                            <option value="editor">Editor</option>
                        </select>
                    </div>

                    <!-- Permissions Section -->
                    <h6 class="fw-bold mt-4">Assign Page Permissions</h6>
                    <div class="table-responsive">
                        <table class="table table-bordered align-middle text-center">
                            <thead class="table-light">
                                <tr>
                                    <th>Page</th>
                                    <th>View</th>
                                    <th>Edit</th>
                                    <th>Delete</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $pages = [
                                        'Dashboard' => 'admin.index',
                                        'All Customers' => 'admin.listCustomer',
                                        'Referred Customers' => 'admin.refer',
                                        'Transaction' => 'admin.listTransaction',
                                        'Policies' => 'admin.listVehicle',
                                        'Inspections' => 'admin.inspect',
                                        'NIID/NAICON Response' => 'admin.response',
                                        'Advocate' => 'admin.advocate',
                                    ];
                                @endphp

                                @foreach($pages as $pageName => $routeName)
                                <tr>
                                    <td>{{ $pageName }}</td>
                                    <td><input type="checkbox" name="permissions[{{ $routeName }}][]" value="view"></td>
                                    <td><input type="checkbox" name="permissions[{{ $routeName }}][]" value="edit"></td>
                                    <td><input type="checkbox" name="permissions[{{ $routeName }}][]" value="delete"></td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn bg-primary text-white">
                        <i class="fas fa-save"></i> Save User
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>




@endsection
