@extends('Layout.admin-dash')
@section('content')
    <div class="main-content">
        <div class="section__content statistic2 section__content--p30">

            {{-- Validation Errors --}}
            @if ($errors->any())
                <div class="alert alert-danger alert-dismissible" role="alert">
                    <strong>Error!</strong> Please check the following:
                    <ul class="list-unstyled">
                        @foreach ($errors->all() as $error)
                            <li><span class="glyphicon glyphicon-remove-sign"></span> {{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            {{-- Success Message --}}
            @if (session('success'))
                <div class="alert alert-success alert-dismissible" role="alert">
                    <strong>Success!</strong> {{ session('success') }}
                </div>
            @endif

            {{-- Error Message --}}
            @if (session('error'))
                <div class="alert alert-danger alert-dismissible" role="alert">
                    <strong>Error!</strong> {{ session('error') }}
                </div>
            @endif

            <div class="container">

                <div class="row">
                    <div class="col-lg-12">
                        <h3 class="title-5 m-b-35">Customer List</h3>
                        <div class="table-data__tool">
                            <div class="table-data__tool-left">
                                <div class="rs-select2--light rs-select2--md">
                                    <select class="js-select2" name="property">
                                        <option selected="selected">All Properties</option>
                                        <option value="">Motor Third Party Insurance</option>
                                        <option value="">Comprehensive Motor Third Party Insurance</option>
                                    </select>
                                    <div class="dropDownSelect2"></div>
                                </div>
                                <div class="rs-select2--light rs-select2--sm">
                                    <select class="js-select2" name="time">
                                        <option selected="selected">Today</option>
                                        <option value="">This Week</option>
                                        <option value="">This Month</option>
                                    </select>
                                    <div class="dropDownSelect2"></div>
                                </div>
                                <button class="au-btn-filter">
                                    <i class="zmdi zmdi-filter-list"></i>filters</button>
                            </div>
                            <div class="table-data__tool-right">
                                <form action="#">
                                    @csrf
                                    <div class="input-group">
                                        <input type="text" id="input3-group2" name="input3-group2" placeholder="Search"
                                            class="form-control">
                                        <div class="input-group-btn">
                                            <button class="btn btn-primary">
                                                <i class="zmdi zmdi-search"></i>
                                            </button>
                                        </div>
                                    </div>
                            </div>
                            </form>

                        </div>
                        <div class="table-responsive table-responsive-data2">
                            <table class="table table-data2">
                                <thead>
                                    <tr>
                                        <th>Customer Name</th>
                                        <th>email</th>
                                        <th>Phone-No</th>
                                        <th>Occupation</th>
                                        <th>State</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if ($customers->count() > 0)
                                        @foreach ($customers as $data)
                                            <tr class="tr-shadow">

                                                <td>{{ $data->fname }} {{ $data->lname }}</td>
                                                <td>
                                                    <span class="block-email">{{ $data->email }}</span>
                                                </td>
                                                <td class="desc">{{ $data->phone_no }}</td>
                                                <td>{{ $data->job }}</td>
                                                <td>{{ $data->state }}</td>
                                                <td>
                                                    <div class="table-data-feature">
                                                        <button class="item" data-toggle="modal" data-placement="top"
                                                            data-target="#mediumModal-{{ $data->id }}" title="Edit">
                                                            <i class="zmdi zmdi-edit"></i>
                                                        </button>

                                                        {{-- <button class="item" data-toggle="tooltip" data-placement="top"
                                                            title="Delete">
                                                            <i class="zmdi zmdi-delete"></i>
                                                        </button> --}}
                                                        <button class="item" data-toggle="modal"
                                                            data-target="#viewModal-{{ $data->id }}"
                                                            data-placement="top" title="View Info">
                                                            <i class="zmdi zmdi-eye"></i>
                                                        </button>

                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="5" class="text-center">No Customer data found</td>
                                        </tr>
                                    @endif


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>






    <!-- modal medium Edi -->
    <div class="main-content">
        @foreach ($customers as $data)
            <div class="modal fade" id="mediumModal-{{ $data->id }}" tabindex="-1" role="dialog"
                aria-labelledby="mediumModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="mediumModalLabel">{{ $data->fname }} {{ $data->lname }}</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">Edit Information</div>
                                    <div class="card-body card-block">
                                        <form action="{{ route('customer.update') }}" method="post">
                                            @csrf
                                            @method('PUT')
                                            <input type="hidden" name="id" value="{{ $data->id }}">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-addon">Title</div>
                                                    <input type="text" id="username3" name="title"
                                                        value="{{ $data->title }}" class="form-control">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-cap"></i>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <div class="col-lg-6">
                                                    <div class="input-group">
                                                        <div class="input-group-addon">First Name</div>
                                                        <input type="text" id="username3" name="fname"
                                                            value="{{ $data->fname }}" class="form-control">
                                                        <div class="input-group-addon">
                                                            <i class="fa fa-user"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="input-group">
                                                        <div class="input-group-addon">Last Name</div>
                                                        <input type="text" id="username3" name="lname"
                                                            value="{{ $data->lname }}" class="form-control">
                                                        <div class="input-group-addon">
                                                            <i class="fa fa-user"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-addon">Email</div>
                                                    <input type="email" id="email3" name="email"
                                                        value="{{ $data->email }}" class="form-control">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-envelope"></i>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-addon">PhoneNo</div>
                                                    <input type="text" id="phone" name="phone_no"
                                                        value="{{ $data->phone_no }}" class="form-control">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-phone"></i>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-addon">DOB</div>
                                                    <input type="text" id="birth" name="dob"
                                                        value="{{ $data->dob }}" class="form-control">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-addon">Address</div>
                                                    <input type="text" id="address" name="address"
                                                        value="{{ $data->address }}" class="form-control">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-map"></i>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-addon">Occupation</div>
                                                    <input type="text" id="job" name="job"
                                                        value="{{ $data->job }}" class="form-control">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-user"></i>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-addon">Gender</div>
                                                    <input type="text" id="sex" name="sex"
                                                        value="{{ $data->gender }}" class="form-control">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-user"></i>
                                                    </div>
                                                </div>
                                            </div>


                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-dismiss="modal">Cancel</button>
                                                <button type="submit" class="btn btn-primary">Confirm Change</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        @endforeach
        <!-- end modal medium -->
    </div>
    <!-- end Edit modal medium -->




    <!-- modal medium view -->
    <div class="main-content">
        @foreach ($customers as $data)
            <div class="modal fade" id="viewModal-{{ $data->id }}" tabindex="-1" role="dialog"
                aria-labelledby="mediumModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="mediumModalLabel">{{ $data->fname }} {{ $data->lname }}</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <div class="modal-body">
                            <div class="col-lg-12">

                                <div class="container mt-4">
                                    <h5 class="text-uppercase font-weight-bold border-bottom pb-2"> Personal Information
                                    </h5>

                                    <table class="table table-bordered">
                                        <tbody>
                                            <tr>
                                                <th>Title</th>
                                                <td>{{ $data->title ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>First Name</th>
                                                <td>{{ $data->fname ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Last Name</th>
                                                <td>{{ $data->lname ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Sex</th>
                                                <td>{{ $data->sex ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Residential Address</th>
                                                <td>{{ $data->address ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>State</th>
                                                <td>{{ $data->state ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Employment</th>
                                                <td>{{ $data->job ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Phone Number</th>
                                                <td>{{ $data->phone_no ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Email</th>
                                                <td>{{ $data->email ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Date Registered</th>
                                                <td>{{ \Carbon\Carbon::parse($data->date)->format('d M, Y') ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Occupation</th>
                                                <td>{{ $data->job ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Date of Birth</th>
                                                <td>{{ $data->dob ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Passport Number</th>
                                                <td>{{ $data->passport_no ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Tax Identification Number (TIN)</th>
                                                <td>{{ $data->tin ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Means of Identification</th>
                                                <td>{{ $data->id_type ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>ID Number</th>
                                                <td>{{ $data->id_no ?? '-' }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        @endforeach
        <!-- end view modal medium -->
    </div>

@endsection
