@extends('Layout.admin-dash')
@section('content')
    <div class="main-content">
        <div class="section__content statistic2 section__content--p30">

            {{-- Validation Errors --}}
            @if ($errors->any())
                <div class="alert alert-danger alert-dismissible" role="alert">
                    <strong>Error!</strong> Please check the following:
                    <ul class="list-unstyled">
                        @foreach ($errors->all() as $error)
                            <li><span class="glyphicon glyphicon-remove-sign"></span> {{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            {{-- Success Message --}}
            @if (session('success'))
                <div class="alert alert-success alert-dismissible" role="alert">
                    <strong>Success!</strong> {{ session('success') }}
                </div>
            @endif

            {{-- Error Message --}}
            @if (session('error'))
                <div class="alert alert-danger alert-dismissible" role="alert">
                    <strong>Error!</strong> {{ session('error') }}
                </div>
            @endif

            <div class="container">

                <div class="row">
                    <div class="col-lg-12">
                        <h3 class="title-5 m-b-35">Advocate User</h3>
                        <div class="table-data__tool">
                            <div class="table-data__tool-left">
                                <div class="rs-select2--light rs-select2--md">
                                    <select class="js-select2" name="property">
                                        <option selected="selected">All Properties</option>
                                        <option value="">Motor Third Party Insurance</option>
                                        <option value="">Comprehensive Motor Third Party Insurance</option>
                                    </select>
                                    <div class="dropDownSelect2"></div>
                                </div>

                                <button class="au-btn-filter">
                                    <i class="zmdi zmdi-filter-list"></i>filters</button>
                            </div>
                            <div class="table-data__tool-right">
                                <form action="#">
                                    @csrf
                                    <div class="input-group">
                                        <input type="text" id="input3-group2" name="input3-group2" placeholder="Search"
                                            class="form-control">
                                        <div class="input-group-btn">
                                            <button class="btn btn-primary">
                                                <i class="zmdi zmdi-search"></i>
                                            </button>
                                        </div>
                                    </div>
                            </div>
                            </form>

                        </div>
                        <div class="table-responsive table-responsive-data2">
                            <table class="table table-data2">
                                <thead>
                                    <tr>
                                        <th> Name</th>
                                        <th>email</th>
                                        <th>Phone-No</th>
                                        <th>Referral Code</th>
                                        <th>Id Number</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if ($advocate->count() > 0)
                                        @foreach ($advocate as $data)
                                            <tr class="tr-shadow">

                                                <td>{{ $data->first_name }} {{ $data->last_name }}</td>
                                                <td>
                                                    <span class="block-email">{{ $data->email }}</span>
                                                </td>
                                                <td class="desc">{{ $data->phone_number }}</td>
                                                <td>{{ $data->referral_code }}</td>
                                                <td>{{ $data->id_number }}</td>
                                                <td>
                                                    <div class="table-data-feature">

                                                        {{-- <button class="item" data-toggle="tooltip" data-placement="top"
                                                            title="Delete">
                                                            <i class="zmdi zmdi-delete"></i>
                                                        </button> --}}
                                                        <button class="item" data-toggle="modal"
                                                            data-target="#viewModal-{{ $data->id }}"
                                                            data-placement="top" title="View Info">
                                                            <i class="zmdi zmdi-eye"></i>
                                                        </button>

                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="5" class="text-center">No Customer data found</td>
                                        </tr>
                                    @endif


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>







    <!-- modal medium view -->
    <div class="main-content">
        @foreach ($advocate as $data)
            <div class="modal fade" id="viewModal-{{ $data->id }}" tabindex="-1" role="dialog"
                aria-labelledby="mediumModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="mediumModalLabel">{{ $data->fname }} {{ $data->lname }}</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <div class="modal-body">
                            <div class="col-lg-12">

                                <div class="container mt-4">
                                    <h5 class="text-uppercase font-weight-bold border-bottom pb-2"> Advocate Information
                                    </h5>

                                    <table class="table table-bordered">
                                        <tbody>
                                            <tr>
                                                <th>First Name</th>
                                                <td>{{ $data->first_name ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Last Name</th>
                                                <td>{{ $data->last_name ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Email</th>
                                                <td>{{ $data->email ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Phone Number</th>
                                                <td>{{ $data->phone_number ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Residential Address</th>
                                                <td>{{ $data->residential_address ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Date of Birth</th>
                                                <td>{{ $data->date_of_birth ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Place of Birth</th>
                                                <td>{{ $data->place_of_birth ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Other Source of Income</th>
                                                <td>{{ $data->other_source_of_income ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Nationality</th>
                                                <td>{{ $data->nationality ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>ID Type</th>
                                                <td>{{ $data->id_type ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>ID Number</th>
                                                <td>{{ $data->id_number ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Referral Code</th>
                                                <td>{{ $data->referral_code ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Referral Count</th>
                                                <td>{{ $data->referral_count ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Commission Earn</th>
                                                <td>{{ $data->total_commission ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Issued Date</th>
                                                <td>{{ $data->issued_date ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Expiry Date</th>
                                                <td>{{ $data->expiry_date ?? '-' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Privacy Policy</th>
                                                <td>{{ $data->privacy_policy ?? '-' }}</td>
                                            </tr>
                                            
                                        </tbody>
                                    </table>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        @endforeach
        <!-- end view modal medium -->
    </div>

@endsection
