@extends('Layout.admin-dash')

@section('title', 'Manage Admins')

@section('content')
    <div class="main-content">
        <div class="section__content statistic2 section__content--p30">

            @if ($errors->any())
            <div class="alert alert-danger alert-dismissible" role="alert">
                <strong>Error!</strong> Please check the following:
                <ul class="list-unstyled">
                    @foreach ($errors->all() as $error)
                        <li><span class="glyphicon glyphicon-remove-sign"></span> {{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        {{-- Success Message --}}
        @if (session('success'))
            <div class="alert alert-success alert-dismissible" role="alert">
                <strong>Success!</strong> {{ session('success') }}
            </div>
        @endif

        {{-- Error Message --}}
        @if (session('error'))
            <div class="alert alert-danger alert-dismissible" role="alert">
                <strong>Error!</strong> {{ session('error') }}
            </div>
        @endif
            <div class="container-fluid">
                <!-- Page Header -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2 class="mb-0 font-weight-bold">Admin Management</h2>
                    <button class="au-btn au-btn-icon au-btn--blue" data-toggle="modal" data-target="#addAdminModal">
                        <i class="fas fa-user-plus"></i>add Admin</button>
                </div>

                <!-- Admins Table -->
                <div class="card shadow-sm">
                    <div class="card-body">
                        @if ($admins->count())
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-hover">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Role</th>
                                            <th>Created At</th>
                                            <th class="text-right">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($admins as $index => $admin)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>{{ $admin->first_name }}</td>
                                                <td>{{ $admin->email }}</td>
                                                <td>
                                                    <span
                                                        class="badge badge-success">{{ ucfirst($admin->user_role) }}</span>
                                                </td>
                                                <td>{{ $admin->created_at->format('d M Y') }}</td>
                                                <td class="text-right">
                                                    <button class="btn btn-sm btn-outline-secondary" data-toggle="modal"
                                                        data-target="#editAdminModal-{{ $admin->id }}">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </button>



                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="text-muted text-center my-3">No admins found.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Admin Modal -->
    <div class="modal fade" id="addAdminModal" tabindex="-1" role="dialog" aria-labelledby="addAdminModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">

                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="addAdminModalLabel">
                        <i class="fas fa-user-shield"></i> Add New Admin User
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>

                <form action="{{ route('admin.addUser') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <!-- Basic Info -->
                        <div class="mb-3">
                            <label class="form-label">Full Name</label>
                            <input type="text" name="first_name" class="form-control" placeholder="Enter full name"
                                required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Email Address</label>
                            <input type="email" name="email" class="form-control" placeholder="Enter email" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Password</label>
                            <input type="password" name="password" class="form-control" placeholder="Enter password"
                                required>
                        </div>

                        <!-- Role Selection -->
                        <div class="mb-3">
                            <label class="form-label">Select Role</label>
                            <select class="form-select" name="role" required>
                                <option value="">-- Choose Role --</option>
                                <option value="super_admin">Super Admin</option>
                                <option value="manager">Manager</option>
                                <option value="editor">Editor</option>
                            </select>
                        </div>

                        <!-- Permissions Section -->
                        <h6 class="fw-bold mt-4">Assign Page Permissions</h6>
                        <div class="table-responsive">
                            <table class="table table-bordered align-middle text-center">
                                <thead class="table-light">
                                    <tr>
                                        <th>Page</th>
                                        <th>View</th>
                                        <th>Edit</th>
                                        <th>Delete</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $pages = [
                                            'Dashboard' => 'admin.index',
                                            'All Customers' => 'admin.listCustomer',
                                            'Referred Customers' => 'admin.refer',
                                            'Transaction' => 'admin.listTransaction',
                                            'Policies' => 'admin.listVehicle',
                                            'Inspections' => 'admin.inspect',
                                            'NIID/NAICON Response' => 'admin.response',
                                            'Advocate' => 'admin.advocate',
                                        ];
                                    @endphp

                                    @foreach ($pages as $pageName => $routeName)
                                        <tr>
                                            <td>{{ $pageName }}</td>
                                            <td><input type="checkbox" name="permissions[{{ $routeName }}][]"
                                                    value="view"></td>
                                            <td><input type="checkbox" name="permissions[{{ $routeName }}][]"
                                                    value="edit"></td>
                                            <td><input type="checkbox" name="permissions[{{ $routeName }}][]"
                                                    value="delete"></td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn bg-primary text-white">
                            <i class="fas fa-save"></i> Save User
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- Edit Admin Modal -->
    @foreach ($admins as $admin)
        <div class="modal fade" id="editAdminModal-{{ $admin->id }}" tabindex="-1" role="dialog"
            aria-labelledby="editAdminModalLabel-{{ $admin->id }}" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content shadow">

                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title" id="editAdminModalLabel-{{ $admin->id }}">
                            <i class="fas fa-user-edit mr-1"></i> Edit Admin User
                        </h5>
                        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>

                    <form action="{{ route('admin.updateUser') }}" method="POST">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="id" value="{{ $admin->id }}">

                        <div class="modal-body">
                            <!-- Basic Info -->
                            <div class="form-group">
                                <label>Full Name</label>
                                <input type="text" name="first_name" class="form-control" value="{{ $admin->first_name }}"
                                    required>
                            </div>

                            <div class="form-group">
                                <label>Email Address</label>
                                <input type="email" name="email" class="form-control" value="{{ $admin->email }}"
                                    required>
                            </div>

                            <div class="form-group">
                                <label>Role</label>
                                <select name="role" class="form-control" required>
                                    <option value="super_admin"
                                        {{ $admin->role->name ?? '' == 'super_admin' ? 'selected' : '' }}>Super Admin
                                    </option>
                                    <option value="manager" {{ $admin->role->name ?? '' == 'manager' ? 'selected' : '' }}>
                                        Manager</option>
                                    <option value="editor" {{ $admin->role->name ?? '' == 'editor' ? 'selected' : '' }}>
                                        Editor</option>
                                </select>
                            </div>

                            <!-- Permissions -->
                            <h6 class="font-weight-bold mt-4">Assign Page Permissions</h6>
                            <div class="table-responsive">
                                <table class="table table-bordered text-center">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Page</th>
                                            <th>View</th>
                                            <th>Edit</th>
                                            <th>Delete</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $pages = [
                                                'Dashboard' => 'admin.index',
                                                'All Customers' => 'admin.listCustomer',
                                                'Referred Customers' => 'admin.refer',
                                                'Transaction' => 'admin.listTransaction',
                                                'Policies' => 'admin.listVehicle',
                                                'Inspections' => 'admin.inspect',
                                                'NIID/NAICON Response' => 'admin.response',
                                                'Advocate' => 'admin.advocate',
                                            ];
                                            $userPermissions = $admin->role
                                                ? $admin->role->permissions
                                                    ->groupBy('page')
                                                    ->map(fn($p) => $p->pluck('action')->toArray())
                                                    ->toArray()
                                                : [];
                                        @endphp

                                        @foreach ($pages as $pageName => $routeName)
                                            <tr>
                                                <td class="text-left">{{ $pageName }}</td>
                                                <td><input type="checkbox" name="permissions[{{ $routeName }}][]"
                                                        value="view"
                                                        {{ isset($userPermissions[$routeName]) && in_array('view', $userPermissions[$routeName]) ? 'checked' : '' }}>
                                                </td>
                                                <td><input type="checkbox" name="permissions[{{ $routeName }}][]"
                                                        value="edit"
                                                        {{ isset($userPermissions[$routeName]) && in_array('edit', $userPermissions[$routeName]) ? 'checked' : '' }}>
                                                </td>
                                                <td><input type="checkbox" name="permissions[{{ $routeName }}][]"
                                                        value="delete"
                                                        {{ isset($userPermissions[$routeName]) && in_array('delete', $userPermissions[$routeName]) ? 'checked' : '' }}>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Admin
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach


@endsection
