<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Utility\Util;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class AuthController extends Controller
{
    public function login(){
        return view('admin.login');
    }
   public function PostLogin(Request $request) {

    $validate = $request->validate([
        'email' =>'required|email',
        'password' => 'required|string'
    ]);


    if (Auth::attempt($validate)) {
        $user = Auth::user();
        $message = "Login successful";
    
        if ($user->user_role === 'admin') {
            return redirect()->route('admin.index')->with(['success' => $message]);
        } else {
            return redirect()->route('advocate.dashboard')->with(['success' => $message]);
        }
    } else {
        return back()->with(['error' => 'Invalid credentials']);
    }    
   }

   public function logout(Request $request)
   {
       // Get the authenticated user
       $user = Util::Auth();
       
       // Log the logout activity (optional)
       Log::info('User logged out', ['user_id' => $user->id]);
       
       // Logout the user
       Auth::logout();
       
       // Invalidate the session
       $request->session()->invalidate();
       
       // Regenerate CSRF token
       $request->session()->regenerateToken();
       
       // Clear any remember me cookie
       if ($request->hasCookie('remember_token')) {
           $cookie = cookie()->forget('remember_token');
           return redirect()->route('login')->withCookie($cookie)->with('success', 'Logged out successfully');
       }
       
       return redirect()->route('login')->with('success', 'You have been logged out successfully');
   }
}
